/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.AbilityModifier;
import com.crowsofwar.avatar.bending.bending.AbilityModifiers;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.bending.bendingmultipliers.PrModifierHandler;
import com.crowsofwar.avatar.config.ConfigChi;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityLightningArc;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.network.packets.PacketCPowerRating;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BenderInfo;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.Chi;
import com.crowsofwar.avatar.util.data.DataCategory;
import com.crowsofwar.avatar.util.data.PowerRatingManager;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.WallJumpManager;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.avatar.util.data.ctx.PlayerBender;
import com.crowsofwar.avatar.util.event.AbilityUseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class Bender {
    protected WallJumpManager wallJumpManager = new WallJumpManager(this);

    @Nullable
    public static Bender get(@Nullable EntityLivingBase entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityBender) {
            return ((EntityBender)entity).getBender();
        }
        if (entity instanceof EntityPlayer) {
            return new PlayerBender((EntityPlayer)entity);
        }
        throw new IllegalArgumentException("Unsure how to get bender for entity " + entity);
    }

    public static boolean isBenderSupported(EntityLivingBase entity) {
        return (entity == null || entity instanceof EntityPlayer && !(entity instanceof FakePlayer) || entity instanceof EntityBender) && Bender.get(entity) != null && Bender.get(entity).getInfo().getId() != null;
    }

    public static void adjustConfigModifier(EntityLivingBase bender) {
        for (Ability ability : Abilities.all()) {
            if (ability.properties == null) continue;
            AbilityModifier modifier = AbilityModifiers.CONFIG_MODIFIER;
            HashMap<String, Number> properties = new HashMap<String, Number>();
            int size = ability.properties.getValues().size();
            for (int i = 0; i < size; ++i) {
                String propertyName = ability.properties.getValues().get(i);
                if (Ability.propertyEqualsInhibitor(propertyName)) {
                    properties.put(propertyName, Float.valueOf(1.0f / ConfigSkills.SKILLS_CONFIG.abilitySettings.powerLevel));
                    continue;
                }
                properties.put(propertyName, Float.valueOf(ConfigSkills.SKILLS_CONFIG.abilitySettings.powerLevel));
            }
            modifier.addProperties(properties);
            BendingData data = BendingData.getFromEntity(bender);
            if (data == null) continue;
            data.getAbilityData(ability).clearModifier();
            data.getAbilityData(ability).addModifiers(modifier);
        }
    }

    public String getName() {
        return this.getEntity().func_70005_c_();
    }

    public abstract EntityLivingBase getEntity();

    public World getWorld() {
        return this.getEntity().field_70170_p;
    }

    public abstract BenderInfo getInfo();

    public abstract BendingData getData();

    public abstract boolean isCreativeMode();

    public abstract boolean isFlying();

    public abstract boolean consumeWaterLevel(int var1);

    public boolean consumeChi(float amount) {
        return true;
    }

    public double calcPowerRating(UUID bendingId) {
        BendingContext ctx = new BendingContext(this.getData(), this.getEntity(), this, new Raytrace.Result());
        PowerRatingManager manager = this.getData().getPowerRatingManager(bendingId);
        if (manager != null) {
            return manager.getRating(ctx);
        }
        return 0.0;
    }

    public double getDamageMult(UUID bendingId) {
        double powerRating = this.calcPowerRating(bendingId);
        if (powerRating < 0.0) {
            return 0.05 * powerRating + 1.0 < 0.0 ? (double)0.02f : 0.05 * powerRating + 1.0;
        }
        return 0.05 * powerRating + 1.0;
    }

    protected boolean canUseAbility(Ability ability) {
        BendingData data = this.getData();
        return data.hasBendingId(ability.getBendingId()) && !data.getAbilityData(ability).isLocked();
    }

    public void executeAbility(Ability ability, boolean switchPath) {
        Raytrace.Result raytrace = Raytrace.getTargetBlock(this.getEntity(), ability.getRaytrace());
        this.executeAbility(ability, raytrace, switchPath);
    }

    public void executeAbility(Ability ability, Raytrace.Result raytrace, boolean switchPath) {
        BendingData data = this.getData();
        EntityLivingBase entity = this.getEntity();
        AbilityData aD = AbilityData.get(this.getEntity(), ability.getName());
        if (aD != null) {
            int level = aD.getLevel();
            double powerRating = this.calcPowerRating(ability.getBendingId());
            AbilityData.AbilityTreePath path = aD.getPath();
            AbilityContext abilityCtx = new AbilityContext(data, raytrace, ability, entity, powerRating, switchPath);
            aD.setSwitchPath(switchPath);
            if (entity instanceof EntityPlayer && ability.properties == null) {
                Ability.syncProperties((EntityPlayer)entity);
            }
            if (ability.properties != null) {
                if (this.canUseAbility(ability) && !MinecraftForge.EVENT_BUS.post((Event)new AbilityUseEvent(entity, ability, level + 1, path))) {
                    if (data.getMiscData().getCanUseAbilities()) {
                        if (this.getData().chi().getAvailableChi() >= ability.getChiCost(abilityCtx) && aD.getAbilityCooldown() == 0 || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                            aD.setPowerRating(this.calcPowerRating(ability.getBendingId()));
                            aD.setRegenBurnout(true);
                            ability.execute(abilityCtx);
                            if (entity instanceof EntityPlayer) {
                                ((EntityPlayer)entity).func_71020_j(ability.getExhaustion(abilityCtx));
                            }
                            aD.setAbilityCooldown(ability.getCooldown(abilityCtx));
                            aD.addBurnout(ability.getBurnOut(abilityCtx));
                            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() && !this.getWorld().field_72995_K) {
                                aD.setAbilityCooldown(0);
                                aD.setBurnOut(0.0f);
                            }
                        } else {
                            Objects.requireNonNull(Bender.get(this.getEntity())).sendMessage("avatar.abilityCooldown");
                        }
                    } else if (this.getWorld().field_72995_K) {
                        AvatarChatMessages.MSG_SKATING_BENDING_DISABLED.send((ICommandSender)this.getEntity(), new Object[0]);
                    }
                } else {
                    this.sendMessage("avatar.abilityLocked");
                }
            } else {
                if (entity instanceof EntityPlayer) {
                    Ability.syncProperties((EntityPlayer)entity);
                }
                Objects.requireNonNull(Bender.get(entity)).sendMessage("avatar.reload");
            }
        }
    }

    public void sendMessage(String message) {
    }

    public boolean redirectLightning(EntityLightningArc lightningArc) {
        return false;
    }

    public void onUpdate() {
        List<TickHandler> tickHandlers;
        BendingData data = this.getData();
        World world = this.getWorld();
        EntityLivingBase entity = this.getEntity();
        List abilities = Abilities.all().stream().filter(ability -> AbilityData.get(entity, ability.getName()).getAbilityCooldown() > 0).collect(Collectors.toList());
        for (Ability ability2 : abilities) {
            AbilityData aD = AbilityData.get(entity, ability2.getName());
            if (aD != null) {
                if (aD.shouldRegenBurnout() && aD.getBurnOut() > 0.0f) {
                    aD.setBurnOut(aD.getBurnOut() - ability2.getProperty("burnOutRecoverTick", aD).floatValue());
                }
                aD.decrementCooldown();
            }
            data.save(DataCategory.ABILITY_DATA);
        }
        BendingContext ctx = new BendingContext(data, entity, this, new Raytrace.Result());
        if (!world.field_72995_K) {
            Chi chi = data.chi();
            if (ConfigChi.CHI_CONFIG.lowChiDebuffs && chi.getMaxChi() > 0.0f) {
                if (chi.getTotalChi() <= chi.getMaxChi() / 15.0f) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 5));
                }
                if (chi.getTotalChi() <= chi.getMaxChi() / 10.0f) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 5));
                }
            }
            if (chi.getAvailableChi() < ConfigChi.CHI_CONFIG.maxAvailableChi) {
                chi.changeAvailableChi(ConfigChi.CHI_CONFIG.availablePerSecond / 20.0f);
            }
            if (data.getPerformance().getScore() != 0.0) {
                chi.changeTotalChi(ConfigChi.CHI_CONFIG.regenInCombat / 20.0f);
            }
            if (entity.func_70608_bn()) {
                chi.changeTotalChi(ConfigChi.CHI_CONFIG.regenInBed / 20.0f);
            } else if (data.hasBendingId(Waterbending.ID) && entity.func_70090_H()) {
                chi.changeTotalChi(ConfigChi.CHI_CONFIG.regenInWater / 20.0f);
            } else if (data.hasBendingId(Airbending.ID)) {
                chi.changeTotalChi(ConfigChi.CHI_CONFIG.regenPerSecond / 15.0f);
            } else if (data.hasBendingId(Earthbending.ID) && ConfigStats.STATS_CONFIG.bendableBlocks.contains(world.func_180495_p(entity.func_180425_c()).func_177230_c())) {
                chi.changeTotalChi(ConfigChi.CHI_CONFIG.regenOnEarth / 20.0f);
            }
        }
        if ((tickHandlers = data.getAllTickHandlers()) != null) {
            for (TickHandler handler : tickHandlers) {
                if (handler == null) continue;
                if (handler.tick(ctx)) {
                    data.removeTickHandler(handler, ctx);
                    continue;
                }
                int newDuration = data.getTickHandlerDuration(handler) + 1;
                data.setTickHandlerDuration(handler, newDuration);
            }
            data.save(DataCategory.TICK_HANDLERS);
        }
        List<PowerRatingManager> managers = data.getPowerRatingManagers();
        for (PowerRatingManager manager : managers) {
            manager.tickModifiers(ctx);
        }
        if (!world.field_72995_K) {
            PrModifierHandler.addPowerRatingModifiers(this);
        }
        if (entity.field_70173_aa - entity.func_142013_aG() > 3) {
            data.getPerformance().update();
        }
        if (entity instanceof EntityPlayer && !world.field_72995_K && entity.field_70173_aa % 10 == 0) {
            this.syncPowerRating();
        }
        data.saveAll();
    }

    public void onDeath() {
        BendingContext ctx = new BendingContext(this.getData(), this.getEntity(), new Raytrace.Result());
        BendingData data = this.getData();
        for (UUID bendingId : data.getAllBendingIds()) {
            PowerRatingManager manager = data.getPowerRatingManager(bendingId);
            manager.clearModifiers(ctx);
        }
        Chi chi = data.chi();
        chi.setTotalChi(chi.getMaxChi());
        chi.setAvailableChi(ConfigChi.CHI_CONFIG.maxAvailableChi);
    }

    private void syncPowerRating() {
        BendingContext ctx = new BendingContext(this.getData(), this.getEntity(), new Raytrace.Result());
        HashMap<UUID, Double> powerRatings = new HashMap<UUID, Double>();
        List<PowerRatingManager> managers = this.getData().getPowerRatingManagers();
        for (PowerRatingManager manager : managers) {
            powerRatings.put(manager.getBendingType(), manager.getRating(ctx));
        }
        AvatarMod.network.sendTo((IMessage)new PacketCPowerRating(powerRatings), (EntityPlayerMP)this.getEntity());
    }

    public WallJumpManager getWallJumpManager() {
        return this.wallJumpManager;
    }
}

