/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BenderInfoEntity;
import com.crowsofwar.avatar.util.data.BenderInfoPlayer;
import com.crowsofwar.avatar.util.data.ctx.NoBenderInfo;
import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class BenderInfo {
    public static BenderInfo readFromNbt(NBTTagCompound nbt) {
        String type = nbt.func_74779_i("Type");
        UUID id = nbt.func_186857_a("Id");
        if (type.equals("Player")) {
            return new BenderInfoPlayer(id);
        }
        if (type.equals("Entity")) {
            return new BenderInfoEntity(id);
        }
        return new NoBenderInfo();
    }

    public static BenderInfo readFromBytes(ByteBuf buf) {
        String type = ByteBufUtils.readUTF8String((ByteBuf)buf);
        UUID id = GoreCoreByteBufUtil.readUUID(buf);
        if (type.equals("Player")) {
            return new BenderInfoPlayer(id);
        }
        if (type.equals("Entity")) {
            return new BenderInfoEntity(id);
        }
        return new NoBenderInfo();
    }

    public static BenderInfo get(boolean player, @Nullable UUID id) {
        if (id == null) {
            return new NoBenderInfo();
        }
        if (player) {
            return new BenderInfoPlayer(id);
        }
        return new BenderInfoEntity(id);
    }

    public static BenderInfo get(@Nullable EntityLivingBase entity) {
        if (entity == null) {
            return new NoBenderInfo();
        }
        if (entity instanceof EntityPlayer) {
            return new BenderInfoPlayer(entity.func_70005_c_());
        }
        return new BenderInfoEntity(entity.func_110124_au());
    }

    public abstract boolean isPlayer();

    @Nullable
    public abstract UUID getId();

    @Nullable
    public abstract Bender find(World var1);

    private String getType() {
        if (this instanceof BenderInfoPlayer) {
            return "Player";
        }
        if (this instanceof BenderInfoEntity) {
            return "Entity";
        }
        return "None";
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74778_a("Type", this.getType());
        if (this.getId() != null) {
            nbt.func_186854_a("Id", this.getId());
        }
    }

    public void writeToBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getType());
        if (this.getId() != null) {
            GoreCoreByteBufUtil.writeUUID(buf, this.getId());
        }
    }
}

