/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.AbilityModifier;
import com.crowsofwar.avatar.bending.bending.BattlePerformanceScore;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.config.ConfigChi;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.AvatarPlayerData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BenderInfo;
import com.crowsofwar.avatar.util.data.Chi;
import com.crowsofwar.avatar.util.data.DataCategory;
import com.crowsofwar.avatar.util.data.MiscData;
import com.crowsofwar.avatar.util.data.PowerRatingManager;
import com.crowsofwar.avatar.util.data.PreAlpha5SaveConverter;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.Vision;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BendingData {
    private static final int CURRENT_SAVE_VERSION = 1;
    private final Consumer<DataCategory> saveCategory;
    private final Runnable saveAll;
    private final Set<UUID> bendings;
    private final Set<StatusControl> statusControls;
    private final Map<String, AbilityData> abilityData;
    private final Set<TickHandler> tickHandlers;
    private final Map<TickHandler, Integer> tickHandlerDuration;
    private final Map<UUID, PowerRatingManager> powerRatingManagers;
    private BattlePerformanceScore performance;
    private UUID activeBending;
    private Chi chi;
    private MiscData miscData;
    private Vision vision;

    public BendingData(Consumer<DataCategory> saveCategory, Runnable saveAll) {
        this.saveCategory = saveCategory;
        this.saveAll = saveAll;
        this.bendings = new HashSet<UUID>();
        this.statusControls = new HashSet<StatusControl>();
        this.abilityData = new HashMap<String, AbilityData>();
        this.tickHandlers = new HashSet<TickHandler>();
        this.tickHandlerDuration = new HashMap<TickHandler, Integer>();
        this.activeBending = null;
        this.chi = new Chi(this);
        this.miscData = new MiscData(() -> this.save(DataCategory.MISC_DATA));
        this.powerRatingManagers = new HashMap<UUID, PowerRatingManager>();
        this.performance = new BattlePerformanceScore(this);
    }

    @Nullable
    public static BendingData getFromEntity(@Nonnull EntityLivingBase entity) {
        if (!Bender.isBenderSupported(entity)) {
            return null;
        }
        return BendingData.get(entity);
    }

    @Nonnull
    public static BendingData get(@Nonnull EntityLivingBase entity) {
        if (Bender.get(entity) == null || Bender.get(entity).getInfo().getId() == null) {
            throw new IllegalArgumentException("Can't get data for an entity without an UUID");
        }
        if (entity instanceof EntityPlayer) {
            return AvatarPlayerData.fetcher().fetch((EntityPlayer)entity).getData();
        }
        return Bender.get(entity).getData();
    }

    @Nullable
    public static BendingData get(World world, UUID playerId) {
        return BendingData.getFromEntity((EntityLivingBase)AvatarEntityUtils.getPlayerFromStringID(playerId.toString()));
    }

    @Nullable
    public static BendingData get(World world, String playerName) {
        return BendingData.getFromEntity((EntityLivingBase)AvatarEntityUtils.getPlayerFromUsername(playerName));
    }

    @Nullable
    public static BendingData get(World world, BenderInfo info) {
        if (info != null && info.isPlayer()) {
            return BendingData.get(world, info.getId());
        }
        Bender bender = info.find(world);
        if (bender != null) {
            return BendingData.get(bender.getEntity());
        }
        return null;
    }

    public int getTotalLevel(BendingStyle style) {
        int totalLevel = 0;
        List abilities = (List)Abilities.all().clone();
        for (Ability ability : abilities) {
            totalLevel += this.getAbilityData(ability).getLevel();
        }
        return totalLevel;
    }

    public boolean canUse(Ability ability) {
        if (this.bendings.contains(ability.getBendingId())) {
            return this.getAbilityData(ability).getLevel() > -1;
        }
        return false;
    }

    public boolean hasElements() {
        return !this.bendings.isEmpty();
    }

    public boolean hasBendingId(UUID bendingId) {
        return this.bendings.contains(bendingId);
    }

    public boolean hasBending(BendingStyle bending) {
        return this.hasBendingId(bending.getId());
    }

    public void addBendingId(UUID bendingId) {
        if (this.bendings.add(bendingId)) {
            this.save(DataCategory.BENDING_LIST);
        }
    }

    public void addBending(BendingStyle bending) {
        this.addBendingId(bending.getId());
    }

    public void removeBendingId(UUID bendingId) {
        if (this.bendings.remove(bendingId)) {
            this.save(DataCategory.BENDING_LIST);
        }
    }

    public void applyModifiersToAll(AbilityModifier ... modifiers) {
        for (Ability ability : Abilities.all()) {
            this.getAbilityData(ability).addModifiers(modifiers);
        }
    }

    public void applyModifiersToAbilities(List<Ability> abilities, AbilityModifier ... modifiers) {
        for (Ability ability : abilities) {
            this.getAbilityData(ability).addModifiers(modifiers);
        }
    }

    public void removeModifiersFromAll(AbilityModifier ... modifiers) {
        for (Ability ability : Abilities.all()) {
            this.getAbilityData(ability).removeModifiers(modifiers);
        }
    }

    public void removeModifiersFromAbilities(List<Ability> abilities, AbilityModifier ... modifiers) {
        for (Ability ability : abilities) {
            this.getAbilityData(ability).removeModifiers(modifiers);
        }
    }

    public Rank getRank(BendingStyle style, int newLevels) {
        List abilities = Abilities.all().stream().filter(ability -> ability.getElement() == style).collect(Collectors.toList());
        int maxLevel = abilities.size() * 4;
        int realLevel = newLevels;
        if (!abilities.isEmpty()) {
            for (Ability ability2 : abilities) {
                realLevel += this.getAbilityData(ability2).getLevel() + 1;
            }
        }
        int level = (int)((float)realLevel / (float)maxLevel * 4.0f);
        switch (level) {
            case 1: {
                return Rank.ACOLYTE;
            }
            case 2: {
                return Rank.ADEPT;
            }
            case 3: {
                return Rank.MASTER;
            }
            case 4: {
                return Rank.GRANDMASTER;
            }
        }
        return Rank.NOVICE;
    }

    public void removeBending(BendingStyle bending) {
        this.removeBendingId(bending.getId());
    }

    public List<BendingStyle> getAllBending() {
        return this.bendings.stream().map(BendingStyles::get).collect(Collectors.toList());
    }

    public void setAllBending(List<BendingStyle> bending) {
        List<UUID> bendingIds = bending.stream().map(BendingStyle::getId).collect(Collectors.toList());
        this.setAllBendingIds(bendingIds);
    }

    public List<UUID> getAllBendingIds() {
        return new ArrayList<UUID>(this.bendings);
    }

    public void setAllBendingIds(List<UUID> bendingIds) {
        this.bendings.clear();
        this.bendings.addAll(bendingIds);
    }

    public void clearBending() {
        this.bendings.clear();
    }

    @Nullable
    public UUID getActiveBendingId() {
        if (!this.bendings.isEmpty() && this.activeBending == null) {
            this.activeBending = this.bendings.iterator().next();
        }
        if (this.activeBending != null && !this.bendings.isEmpty() && !this.bendings.contains(this.activeBending)) {
            this.activeBending = this.bendings.iterator().next();
        }
        if (this.bendings.isEmpty() && this.activeBending != null) {
            this.activeBending = null;
        }
        return this.activeBending;
    }

    public void setActiveBendingId(UUID id) {
        if (this.bendings.contains(id)) {
            this.activeBending = id;
            this.save(DataCategory.ACTIVE_BENDING);
        }
    }

    @Nullable
    public BendingStyle getActiveBending() {
        return BendingStyles.get(this.getActiveBendingId());
    }

    public void setActiveBending(BendingStyle bending) {
        this.setActiveBendingId(bending.getId());
    }

    public boolean hasStatusControl(StatusControl control) {
        return this.statusControls.contains(control);
    }

    public void addStatusControl(StatusControl control) {
        if (this.statusControls.add(control)) {
            this.save(DataCategory.STATUS_CONTROLS);
        }
    }

    public void addStatusControls(StatusControl ... controls) {
        for (StatusControl sc : controls) {
            if (!this.statusControls.add(sc)) continue;
            this.save(DataCategory.STATUS_CONTROLS);
        }
    }

    public void removeStatusControl(StatusControl control) {
        if (this.statusControls.remove(control)) {
            this.save(DataCategory.STATUS_CONTROLS);
        }
    }

    public void removeStatusControls(StatusControl ... controls) {
        for (StatusControl sc : controls) {
            if (!this.statusControls.remove(sc)) continue;
            this.save(DataCategory.STATUS_CONTROLS);
        }
    }

    public List<StatusControl> getAllStatusControls() {
        return new ArrayList<StatusControl>(this.statusControls);
    }

    public void setAllStatusControls(List<StatusControl> controls) {
        this.statusControls.clear();
        this.statusControls.addAll(controls);
    }

    public void clearStatusControls() {
        this.statusControls.clear();
    }

    public boolean hasAbilityData(String abilityName) {
        return this.abilityData.get(abilityName) != null;
    }

    public boolean hasAbilityData(Ability ability) {
        return this.hasAbilityData(ability.getName());
    }

    public AbilityData getAbilityData(String abilityName) {
        AbilityData data = this.abilityData.get(abilityName);
        if (data == null) {
            data = new AbilityData(this, Abilities.get(abilityName));
            this.abilityData.put(abilityName, data);
            this.save(DataCategory.ABILITY_DATA);
        }
        return data;
    }

    public AbilityData getAbilityData(Ability ability) {
        return this.getAbilityData(ability.getName());
    }

    public void setAbilityData(String abilityName, AbilityData data) {
        this.abilityData.put(abilityName, data);
    }

    public void setAbilityData(Ability ability, AbilityData data) {
        this.setAbilityData(ability.getName(), data);
    }

    public List<AbilityData> getAllAbilityData() {
        return new ArrayList<AbilityData>(this.abilityData.values());
    }

    public Map<String, AbilityData> getAbilityDataMap() {
        return new HashMap<String, AbilityData>(this.abilityData);
    }

    public void setAbilityDataMap(Map<String, AbilityData> map) {
        this.abilityData.clear();
        this.abilityData.putAll(map);
    }

    public void clearAbilityData() {
        this.abilityData.clear();
    }

    public Chi chi() {
        return this.chi;
    }

    public void setChi(Chi chi) {
        this.chi = chi;
        this.save(DataCategory.CHI);
    }

    public void updateMaxChi() {
        float chi = 0.0f;
        chi += (float)this.getAllBending().size() * ConfigChi.CHI_CONFIG.bonusLearnedBending;
        for (AbilityData aData : this.getAllAbilityData()) {
            boolean hasBending;
            boolean bl = hasBending = aData.getAbility() != null && this.hasBendingId(aData.getAbility().getBendingId());
            if (aData.isLocked() || !hasBending) continue;
            chi += ConfigChi.CHI_CONFIG.bonusAbility;
            chi += (float)aData.getLevel() * ConfigChi.CHI_CONFIG.bonusAbilityLevel;
        }
        if (chi >= ConfigChi.CHI_CONFIG.maxChiCap) {
            chi = ConfigChi.CHI_CONFIG.maxChiCap;
        }
        if (chi != this.chi().getMaxChi()) {
            float old = this.chi().getMaxChi();
            this.chi().setMaxChi(chi);
            if (chi > old) {
                this.chi().changeTotalChi(chi - old);
            }
        }
    }

    public boolean hasTickHandler(TickHandler handler) {
        return this.tickHandlers.contains(handler);
    }

    public int getTickHandlerDuration(TickHandler handler) {
        if (this.hasTickHandler(handler) && this.tickHandlerDuration != null) {
            return this.tickHandlerDuration.getOrDefault(handler, 0);
        }
        return -1;
    }

    public void setTickHandlerDuration(TickHandler handler, int duration) {
        if (this.hasTickHandler(handler)) {
            this.tickHandlerDuration.put(handler, duration);
        }
    }

    public void addTickHandler(TickHandler handler, BendingContext ctx) {
        if (this.tickHandlers.add(handler)) {
            handler.onAdded(ctx);
            this.tickHandlerDuration.put(handler, 0);
            this.save(DataCategory.TICK_HANDLERS);
        }
    }

    public void removeTickHandler(TickHandler handler, BendingContext ctx) {
        if (this.tickHandlers.remove(handler)) {
            handler.onRemoved(ctx);
            this.tickHandlerDuration.remove(handler);
            this.save(DataCategory.TICK_HANDLERS);
        }
    }

    public List<TickHandler> getAllTickHandlers() {
        return new ArrayList<TickHandler>(this.tickHandlers);
    }

    public void setAllTickHandlers(List<TickHandler> handlers) {
        this.tickHandlers.clear();
        this.tickHandlers.addAll(handlers);
        Map newDurations = handlers.stream().collect(Collectors.toMap(Function.identity(), this::getTickHandlerDuration));
        this.tickHandlerDuration.clear();
        this.tickHandlerDuration.putAll(newDurations);
    }

    public void clearTickHandlers() {
        this.tickHandlers.clear();
        this.tickHandlerDuration.clear();
    }

    @Nullable
    public PowerRatingManager getPowerRatingManager(UUID bendingId) {
        if (this.hasBendingId(bendingId)) {
            return this.powerRatingManagers.computeIfAbsent(bendingId, PowerRatingManager::new);
        }
        this.powerRatingManagers.remove(bendingId);
        return null;
    }

    @Nullable
    public PowerRatingManager getPowerRatingManager(BendingStyle bendingStyle) {
        return this.getPowerRatingManager(bendingStyle.getId());
    }

    public List<PowerRatingManager> getPowerRatingManagers() {
        Iterator<Map.Entry<UUID, PowerRatingManager>> iterator = this.powerRatingManagers.entrySet().iterator();
        while (iterator.hasNext()) {
            UUID bendingId = iterator.next().getKey();
            if (this.hasBendingId(bendingId)) continue;
            iterator.remove();
        }
        return new ArrayList<PowerRatingManager>(this.powerRatingManagers.values());
    }

    @Nullable
    public Vision getVision() {
        return this.vision;
    }

    public void setVision(@Nullable Vision vision) {
        if (this.vision != vision) {
            this.vision = vision;
            this.save(DataCategory.VISION);
        }
    }

    public BattlePerformanceScore getPerformance() {
        return this.performance;
    }

    public void setPerformance(BattlePerformanceScore performance) {
        this.performance = performance;
    }

    public MiscData getMiscData() {
        return this.miscData;
    }

    public void setMiscData(MiscData md) {
        this.miscData = md;
    }

    public void writeToNbt(NBTTagCompound writeTo) {
        if (this.activeBending != null) {
            writeTo.func_74778_a("activeBending", this.activeBending.toString());
        }
        AvatarUtils.writeList(this.bendings, (nbt, controllerId) -> nbt.func_186854_a("ControllerID", controllerId), writeTo, "BendingControllers");
        AvatarUtils.writeList(this.statusControls, (nbt, control) -> nbt.func_74768_a("Id", control.id()), writeTo, "StatusControls");
        AvatarUtils.writeMap(this.getAbilityDataMap(), (nbt, abilityName) -> nbt.func_74778_a("Name", abilityName), (nbt, data) -> {
            nbt.func_74778_a("Name", data.getAbilityName());
            data.writeToNbt((NBTTagCompound)nbt);
        }, writeTo, "AbilityData");
        this.getMiscData().writeToNbt(GoreCoreNBTUtil.nestedCompound(writeTo, "Misc"));
        this.chi().writeToNBT(writeTo);
        AvatarUtils.writeList(this.tickHandlers, (nbt, handler) -> {
            if (handler != null && nbt != null) {
                nbt.func_74768_a("Id", handler.id());
            }
        }, writeTo, "TickHandlers");
        writeTo.func_74780_a("BattlePerformance", this.getPerformance().getScore());
        writeTo.func_74768_a("SaveVersion", 1);
    }

    public void readFromNbt(NBTTagCompound readFrom) {
        if (!readFrom.func_74764_b("SaveVersion") && !readFrom.func_74764_b("HurtByTimestamp")) {
            AvatarLog.info("Detected pre-a5.0 save data, converting...");
            AvatarLog.info(readFrom.toString());
            readFrom = PreAlpha5SaveConverter.convertSave(readFrom, 1);
            AvatarLog.info(readFrom.toString());
        }
        AvatarUtils.readList(this.bendings, nbt -> nbt.func_186857_a("ControllerID"), readFrom, "BendingControllers");
        if (readFrom.func_74764_b("activeBending")) {
            this.setActiveBendingId(UUID.fromString(readFrom.func_74779_i("activeBending")));
        }
        AvatarUtils.readList(this.statusControls, nbt -> StatusControlController.lookup(nbt.func_74762_e("Id")), readFrom, "StatusControls");
        AvatarUtils.readMap(this.abilityData, nbt -> nbt.func_74779_i("Name"), nbt -> {
            String abilityName = nbt.func_74779_i("Name");
            AbilityData data = new AbilityData(this, abilityName);
            data.readFromNbt((NBTTagCompound)nbt);
            return data;
        }, readFrom, "AbilityData");
        this.getMiscData().readFromNbt(GoreCoreNBTUtil.nestedCompound(readFrom, "Misc"));
        this.chi().readFromNBT(readFrom);
        AvatarUtils.readList(this.tickHandlers, nbt -> TickHandlerController.fromId(nbt.func_74762_e("Id")), readFrom, "TickHandlers");
        for (TickHandler tickHandler : this.tickHandlers) {
            this.tickHandlerDuration.putIfAbsent(tickHandler, 0);
        }
        this.getPerformance().setScore(readFrom.func_74769_h("BattlePerformance"));
    }

    public void save(DataCategory category) {
        this.saveCategory.accept(category);
    }

    public void saveAll() {
        this.saveAll.run();
    }

    public static enum Rank {
        NOVICE,
        ACOLYTE,
        ADEPT,
        MASTER,
        GRANDMASTER;

    }
}

