/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.gorecore.util.AccountUUIDs;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class CachedEntity<T extends Entity> {
    private T cachedEntity;
    private UUID entityId;

    public CachedEntity(@Nullable UUID id) {
        this.entityId = id;
    }

    private static UUID getId(Entity entity) {
        return entity instanceof EntityPlayer ? AccountUUIDs.getId(entity.func_70005_c_()) : entity.func_110124_au();
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.entityId = nbt.func_74767_n("NoEntity") ? null : nbt.func_186857_a("EntityUuid");
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74757_a("NoEntity", this.entityId == null);
        if (this.entityId != null) {
            nbt.func_186854_a("EntityUuid", this.entityId);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readBoolean() ? null : new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.entityId == null);
        if (this.entityId != null) {
            buf.writeLong(this.entityId.getMostSignificantBits());
            buf.writeLong(this.entityId.getLeastSignificantBits());
        }
    }

    @Nullable
    public UUID getEntityId() {
        return this.entityId;
    }

    public void setEntityId(@Nullable UUID entityId) {
        this.entityId = entityId;
    }

    @Nullable
    public T getEntity(World world) {
        if (this.isCacheInvalid()) {
            List list = world.func_175644_a(Entity.class, entity -> CachedEntity.getId(entity).equals(this.entityId));
            this.cachedEntity = list.isEmpty() ? null : (Entity)list.get(0);
        }
        return this.cachedEntity;
    }

    public void setEntity(@Nullable T entity) {
        this.cachedEntity = entity;
        this.entityId = entity == null ? null : CachedEntity.getId(entity);
    }

    private boolean isCacheInvalid() {
        return this.cachedEntity == null || ((Entity)this.cachedEntity).field_70128_L || this.cachedEntity.func_110124_au() != this.entityId;
    }
}

