/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.DataCategory;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class Chi {
    private final BendingData data;
    private float max;
    private float total;
    private float availableMark;

    public Chi(BendingData data) {
        this.data = data;
        this.max = 20.0f;
        this.total = 10.0f;
        this.availableMark = 8.0f;
    }

    public float getTotalChi() {
        return this.total;
    }

    public void setTotalChi(float total) {
        this.total = total;
        this.save();
    }

    public void changeTotalChi(float amount) {
        float prev = this.total;
        this.total = this.total + amount > this.max ? this.max : (this.total + amount < 0.0f ? 0.0f : (this.total += amount));
        this.availableMark += this.total - prev;
        if (Math.abs(this.availableMark) > this.total) {
            this.availableMark = 0.0f;
        }
        this.save();
    }

    public float getMaxChi() {
        return this.max;
    }

    public void setMaxChi(float max) {
        this.max = max;
        if (max < this.total) {
            this.setTotalChi(max);
        }
        this.save();
    }

    public float getAvailableChi() {
        return this.total - this.availableMark;
    }

    public void setAvailableChi(float available) {
        if (available > this.total) {
            available = this.total;
        }
        this.availableMark = this.total - available;
        this.save();
    }

    public void changeAvailableChi(float amount) {
        this.setAvailableChi(this.getAvailableChi() + amount);
    }

    public float getAvailableMaxChi() {
        return this.max - this.availableMark;
    }

    public boolean consumeChi(float amount) {
        float available = this.getAvailableChi();
        if (available >= amount) {
            this.changeTotalChi(-amount);
            this.changeAvailableChi(-amount);
            return true;
        }
        return false;
    }

    private void save() {
        this.checkConsistency();
        this.data.save(DataCategory.CHI);
    }

    private void checkConsistency() {
        if (this.total < 0.0f) {
            this.total = 0.0f;
        }
        if (this.total > this.max) {
            this.total = this.max;
        }
        if (this.availableMark > this.total) {
            this.availableMark = this.total;
        }
        if (this.availableMark < 0.0f) {
            this.availableMark = 0.0f;
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound nbt = GoreCoreNBTUtil.nestedCompound(compound, "ChiData");
        this.max = nbt.func_74760_g("Max");
        this.total = nbt.func_74760_g("Current");
        this.availableMark = nbt.func_74760_g("AvailableMark");
        if (this.max == 0.0f) {
            this.max = 20.0f;
            this.total = 10.0f;
            this.availableMark = 8.0f;
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound nbt = GoreCoreNBTUtil.nestedCompound(compound, "ChiData");
        nbt.func_74776_a("Max", this.max);
        nbt.func_74776_a("Current", this.total);
        nbt.func_74776_a("AvailableMark", this.availableMark);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.max);
        buf.writeFloat(this.total);
        buf.writeFloat(this.availableMark);
    }

    public void fromBytes(ByteBuf buf) {
        this.max = buf.readFloat();
        this.total = buf.readFloat();
        this.availableMark = buf.readFloat();
    }
}

