/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.network.DataTransmitter;
import com.crowsofwar.avatar.network.DataTransmitters;
import com.crowsofwar.avatar.util.data.BendingData;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.Function;

public enum DataCategory {
    BENDING_LIST(BendingData::getAllBendingIds, BendingData::setAllBendingIds, DataTransmitters.BENDING_LIST),
    STATUS_CONTROLS(BendingData::getAllStatusControls, BendingData::setAllStatusControls, DataTransmitters.STATUS_CONTROLS),
    ABILITY_DATA(BendingData::getAbilityDataMap, BendingData::setAbilityDataMap, DataTransmitters.ABILITY_DATA),
    CHI(BendingData::chi, BendingData::setChi, DataTransmitters.CHI),
    MISC_DATA(BendingData::getMiscData, BendingData::setMiscData, DataTransmitters.MISC_DATA),
    TICK_HANDLERS(BendingData::getAllTickHandlers, BendingData::setAllTickHandlers, DataTransmitters.TICK_HANDLERS),
    ACTIVE_BENDING(BendingData::getActiveBendingId, BendingData::setActiveBendingId, DataTransmitters.ACTIVE_BENDING),
    VISION(BendingData::getVision, BendingData::setVision, DataTransmitters.VISION),
    PERFORMANCE(BendingData::getPerformance, BendingData::setPerformance, DataTransmitters.PERFORMANCE);

    private final Function<BendingData, ?> getter;
    private final BiConsumer<BendingData, ?> setter;
    private final DataTransmitter<?> transmitter;

    private <T> DataCategory(Function<BendingData, T> getter, BiConsumer<BendingData, T> setter, DataTransmitter<?> transmitter) {
        this.getter = getter;
        this.setter = setter;
        this.transmitter = transmitter;
    }

    public void write(ByteBuf buf, BendingData data) {
        this.transmitter.write(buf, this.getter.apply(data));
    }

    public void read(ByteBuf buf, BendingData data) {
        Object obj = this.transmitter.read(buf, data);
        this.setter.accept(data, obj);
    }
}

