/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.util.data.BenderInfo;
import com.crowsofwar.avatar.util.data.ctx.NoBenderInfo;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class MiscData {
    private final Runnable save;
    private float fallAbsorption;
    private int timeInAir;
    private boolean wallJumping;
    private int petSummonCooldown;
    private boolean bisonFollowMode;
    private boolean canUseAbilities;
    private BenderInfo redirectionSource;

    public MiscData(Runnable save) {
        this.save = save;
        this.bisonFollowMode = true;
        this.canUseAbilities = true;
        this.redirectionSource = new NoBenderInfo();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.fallAbsorption);
        buf.writeInt(this.timeInAir);
        buf.writeBoolean(this.wallJumping);
        buf.writeInt(this.petSummonCooldown);
        buf.writeBoolean(this.bisonFollowMode);
        buf.writeBoolean(this.canUseAbilities);
    }

    public void fromBytes(ByteBuf buf) {
        this.fallAbsorption = buf.readFloat();
        this.timeInAir = buf.readInt();
        this.wallJumping = buf.readBoolean();
        this.petSummonCooldown = buf.readInt();
        this.bisonFollowMode = buf.readBoolean();
        this.canUseAbilities = buf.readBoolean();
        this.save.run();
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.fallAbsorption = nbt.func_74760_g("FallAbsorption");
        this.timeInAir = nbt.func_74762_e("TimeInAir");
        this.wallJumping = nbt.func_74767_n("WallJumping");
        this.petSummonCooldown = nbt.func_74762_e("PetSummonCooldown");
        this.bisonFollowMode = nbt.func_74767_n("BisonFollowMode");
        this.canUseAbilities = nbt.func_74767_n("CanUseAbilitiesA4.6");
        if (!nbt.func_74764_b("CanUseAbilitiesA4.6")) {
            this.canUseAbilities = true;
        }
        this.redirectionSource = BenderInfo.readFromNbt(nbt);
        this.save.run();
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74776_a("FallAbsorption", this.fallAbsorption);
        nbt.func_74768_a("TimeInAir", this.timeInAir);
        nbt.func_74757_a("WallJumping", this.wallJumping);
        nbt.func_74768_a("PetSummonCooldown", this.petSummonCooldown);
        nbt.func_74757_a("BisonFollowMode", this.bisonFollowMode);
        nbt.func_74757_a("CanUseAbilitiesA4.6", this.canUseAbilities);
        this.redirectionSource.writeToNbt(nbt);
        this.save.run();
    }

    public float getFallAbsorption() {
        return this.fallAbsorption;
    }

    public void setFallAbsorption(float fallAbsorption) {
        if (fallAbsorption == 0.0f || fallAbsorption > this.fallAbsorption) {
            this.fallAbsorption = fallAbsorption;
        }
    }

    public void addFallAbsorption(float fallAbsorption) {
        if (fallAbsorption < 0.0f) {
            fallAbsorption = 0.0f;
        }
        this.fallAbsorption += fallAbsorption;
    }

    public int getTimeInAir() {
        return this.timeInAir;
    }

    public void setTimeInAir(int time) {
        this.timeInAir = time;
    }

    public boolean isWallJumping() {
        return this.wallJumping;
    }

    public void setWallJumping(boolean wallJumping) {
        this.wallJumping = wallJumping;
    }

    public int getPetSummonCooldown() {
        return this.petSummonCooldown;
    }

    public void setPetSummonCooldown(int petSummonCooldown) {
        this.petSummonCooldown = petSummonCooldown;
    }

    public boolean getBisonFollowMode() {
        return this.bisonFollowMode;
    }

    public void setBisonFollowMode(boolean followMode) {
        this.bisonFollowMode = followMode;
    }

    public boolean getCanUseAbilities() {
        return this.canUseAbilities;
    }

    public void setCanUseAbilities(boolean canUseAbilities) {
        this.canUseAbilities = canUseAbilities;
    }

    @Nonnull
    public BenderInfo getRedirectionSource() {
        return this.redirectionSource;
    }

    public void setRedirectionSource(@Nonnull BenderInfo redirectionSource) {
        if (redirectionSource == null) {
            redirectionSource = new NoBenderInfo();
        }
        this.redirectionSource = redirectionSource;
    }
}

