/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.util.data.PowerRatingModifier;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.math.MathHelper;

public class PowerRatingManager {
    private final UUID bendingType;
    private final List<PowerRatingModifier> modifiers;
    private double cachedValue;
    private boolean useCache;

    public PowerRatingManager(UUID bendingType) {
        this.bendingType = bendingType;
        this.modifiers = new ArrayList<PowerRatingModifier>();
        this.cachedValue = 0.0;
        this.useCache = false;
    }

    public double getRating(BendingContext ctx) {
        if (this.useCache) {
            return this.cachedValue;
        }
        double result = 0.0;
        for (PowerRatingModifier modifier : this.modifiers) {
            result += modifier.get(ctx);
        }
        return MathHelper.func_151237_a((double)result, (double)-1000.0, (double)1000.0);
    }

    public void addModifier(PowerRatingModifier modifier, BendingContext ctx) {
        modifier.onAdded(ctx);
        this.modifiers.add(modifier);
    }

    public void removeModifier(PowerRatingModifier modifier, BendingContext ctx) {
        modifier.onRemoval(ctx);
        this.modifiers.remove(modifier);
    }

    public boolean hasModifier(Class<? extends PowerRatingModifier> modifier) {
        for (PowerRatingModifier mod : this.modifiers) {
            if (mod.getClass() != modifier) continue;
            return true;
        }
        return false;
    }

    public void tickModifiers(BendingContext ctx) {
        Iterator<PowerRatingModifier> iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            PowerRatingModifier modifier = iterator.next();
            if (!modifier.onUpdate(ctx)) continue;
            modifier.onRemoval(ctx);
            iterator.remove();
        }
    }

    public void clearModifiers(BendingContext ctx) {
        Iterator<PowerRatingModifier> iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            PowerRatingModifier modifier = iterator.next();
            modifier.onRemoval(ctx);
            iterator.remove();
        }
    }

    public UUID getBendingType() {
        return this.bendingType;
    }

    public void setCachedRatingValue(double value) {
        this.cachedValue = value;
        this.useCache = true;
    }
}

