/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PreAlpha5SaveConverter {
    private static final Map<Integer, UUID> bendingIdConversion = new HashMap<Integer, UUID>();

    public static NBTTagCompound convertSave(NBTTagCompound preA5, int currentSaveVersion) {
        NBTTagCompound converted = preA5.func_74737_b();
        PreAlpha5SaveConverter.fixAbilityData(converted);
        PreAlpha5SaveConverter.fixBendingControllers(converted);
        converted.func_74768_a("SaveVersion", currentSaveVersion);
        return converted;
    }

    private static void fixAbilityData(NBTTagCompound nbt) {
        NBTTagList listTag = nbt.func_150295_c("AbilityData", 10);
        for (int i = 0; i < listTag.func_74745_c(); ++i) {
            NBTTagCompound item = listTag.func_150305_b(i);
            NBTTagCompound keyTag = item.func_74775_l("Key");
            String abilityName = keyTag.func_74779_i("_AbilityName");
            if (abilityName.equals("")) {
                return;
            }
            keyTag.func_74778_a("Name", abilityName);
            keyTag.func_82580_o("_AbilityName");
            keyTag.func_82580_o("Id");
            NBTTagCompound valueTag = item.func_74775_l("Value");
            valueTag.func_82580_o("AbilityId");
            valueTag.func_74778_a("Name", abilityName);
        }
    }

    private static void fixBendingControllers(NBTTagCompound nbt) {
        NBTTagList listTag = nbt.func_150295_c("BendingControllers", 10);
        for (int i = 0; i < listTag.func_74745_c(); ++i) {
            NBTTagCompound item = listTag.func_150305_b(i);
            if (!item.func_150297_b("ControllerID", 3)) continue;
            int oldId = item.func_74762_e("ControllerID");
            item.func_82580_o("ControllerID");
            UUID newId = bendingIdConversion.get(oldId);
            item.func_186854_a("ControllerID", newId);
        }
    }

    static {
        bendingIdConversion.put(1, Earthbending.ID);
        bendingIdConversion.put(2, Firebending.ID);
        bendingIdConversion.put(3, Waterbending.ID);
        bendingIdConversion.put(4, Airbending.ID);
    }
}

