/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.entity.EntitySandstorm;
import com.crowsofwar.gorecore.util.Vector;
import javax.annotation.Nullable;

public class SandstormMovementHandler {
    private static final double BASE_SPEED = 8.0;
    private final EntitySandstorm sandstorm;
    @Nullable
    private Vector targetVelocity;

    public SandstormMovementHandler(EntitySandstorm sandstorm) {
        this.sandstorm = sandstorm;
        this.targetVelocity = null;
    }

    public void update() {
        if (this.targetVelocity != null) {
            double desiredSpeed = this.sandstorm.getVelocityMultiplier() * 8.0f;
            Vector desiredVelocity = this.targetVelocity.times(desiredSpeed);
            double changeFactor = 0.1;
            this.sandstorm.setVelocity(this.sandstorm.velocity().times(1.0 - changeFactor).plus(desiredVelocity.times(changeFactor)));
        } else if (this.sandstorm.field_70173_aa % 2 == 0) {
            double desiredSpeed = this.sandstorm.getVelocityMultiplier() * 8.0f;
            Vector newVelocity = this.sandstorm.velocity().normalize().times(desiredSpeed);
            this.sandstorm.setVelocity(newVelocity);
        }
    }

    public void setTargetVelocity(@Nullable Vector targetVelocity) {
        this.targetVelocity = targetVelocity;
    }
}

