/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.ArrayList;

public abstract class StatusControl {
    private final int texture;
    private final AvatarControl control;
    private final CrosshairPosition position;
    private final int id;
    private Raytrace.Info raytrace;

    public StatusControl(int texture, AvatarControl subscribeTo, CrosshairPosition position) {
        if (StatusControlController.allControls == null) {
            StatusControlController.allControls = new ArrayList<StatusControl>();
        }
        this.texture = texture;
        this.control = subscribeTo;
        this.raytrace = new Raytrace.Info();
        this.position = position;
        this.id = ++StatusControlController.nextId;
        StatusControlController.allControls.add(this);
    }

    protected void requireRaytrace(int range, boolean raycastLiquids) {
        this.raytrace = new Raytrace.Info(range, raycastLiquids);
    }

    public abstract boolean execute(BendingContext var1);

    public int id() {
        return this.id;
    }

    public AvatarControl getSubscribedControl() {
        return this.control;
    }

    public Raytrace.Info getRaytrace() {
        return this.raytrace;
    }

    public int getTextureU() {
        return this.texture * 16 % 256;
    }

    public int getTextureV() {
        return this.texture / 16 * 16;
    }

    public CrosshairPosition getPosition() {
        return this.position;
    }

    public static enum CrosshairPosition {
        ABOVE_CROSSHAIR(4, 14),
        LEFT_OF_CROSSHAIR(14, 3),
        RIGHT_OF_CROSSHAIR(-6, 3),
        BELOW_CROSSHAIR(4, -8);

        private final int x;
        private final int y;

        private CrosshairPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int xOffset() {
            return this.x;
        }

        public int yOffset() {
            return this.y;
        }
    }
}

