/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.MiscData;
import com.crowsofwar.gorecore.util.Vector;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WallJumpManager {
    private final Bender bender;

    public WallJumpManager(Bender bender) {
        this.bender = bender;
    }

    public void doWallJump(ResourceLocation particleType) {
        World world = this.bender.getWorld();
        EntityLivingBase entity = this.bender.getEntity();
        Vector normal = this.getHorizontalCollisionNormal();
        Block block = this.getHorizontalCollisionBlock();
        if (normal != Vector.UP && normal != null) {
            Vector velocity = new Vector(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            Vector n = velocity.reflect(normal).times(4.0).minus(normal.times(0.5)).withY(0.5);
            if ((n = n.plus(Vector.getLookRectangular((Entity)entity).times(-1.25).withY(1.0))).sqrMagnitude() > 1.0) {
                n = n.normalize().times(1.0);
            }
            entity.field_70159_w *= 0.0;
            entity.field_70181_x *= 0.0;
            entity.field_70179_y *= 0.0;
            entity.field_70159_w += n.x();
            entity.field_70181_x += n.y();
            entity.field_70179_y += n.z();
            AvatarUtils.afterVelocityAdded((Entity)entity);
            world.func_184133_a(null, new BlockPos((Entity)entity), block.func_185467_w().func_185845_c(), SoundCategory.PLAYERS, 1.0f, 0.6f);
            this.bender.getData().getMiscData().addFallAbsorption(3.0f);
            if (particleType == ParticleBuilder.Type.FLASH && ConfigStats.STATS_CONFIG.allowMultiAirbendingWalljump) {
                this.bender.getData().getMiscData().setWallJumping(true);
            }
        }
    }

    public boolean canWallJump() {
        EntityLivingBase entity = this.bender.getEntity();
        boolean collidedWithWall = this.bender.getWorld().field_72995_K ? entity.field_70123_F && !entity.field_70124_G : this.getHorizontalCollisionBlock() != null;
        MiscData md = this.bender.getData().getMiscData();
        return collidedWithWall && !md.isWallJumping() && md.getTimeInAir() >= ConfigStats.STATS_CONFIG.wallJumpDelay;
    }

    public boolean knowsWallJump() {
        return this.getWallJumpParticleType() != null;
    }

    @Nullable
    public ResourceLocation getWallJumpParticleType() {
        if (this.bender.getData().hasBending(new Airbending())) {
            return ParticleBuilder.Type.FLASH;
        }
        return null;
    }

    @Nullable
    private Vector getHorizontalCollisionNormal() {
        EntityLivingBase entity = this.bender.getEntity();
        BlockPos pos = new BlockPos((Entity)entity);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos adjusted = pos.func_177972_a(facing);
            if (this.bender.getWorld().func_175623_d(adjusted)) continue;
            return new Vector(facing.func_176730_m());
        }
        return null;
    }

    @Nullable
    private Block getHorizontalCollisionBlock() {
        EntityLivingBase entity = this.bender.getEntity();
        BlockPos pos = new BlockPos((Entity)entity);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos adjusted = pos.func_177972_a(facing);
            if (this.bender.getWorld().func_175623_d(adjusted)) continue;
            return this.bender.getWorld().func_180495_p(adjusted).func_177230_c();
        }
        return null;
    }
}

