/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data.ctx;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import net.minecraft.entity.EntityLivingBase;

public class AbilityContext
extends BendingContext {
    private final Ability ability;
    private final double powerRating;
    private final boolean switchPath;

    public AbilityContext(BendingData data, Raytrace.Result raytrace, Ability ability, EntityLivingBase entity, double powerRating, boolean switchPath) {
        super(data, entity, raytrace);
        this.ability = ability;
        this.powerRating = powerRating;
        this.switchPath = switchPath;
    }

    public AbilityContext(BendingData data, EntityLivingBase entity, Bender bender, Raytrace.Result raytrace, Ability ability, double powerRating, boolean switchPath) {
        super(data, entity, bender, raytrace);
        this.ability = ability;
        this.powerRating = powerRating;
        this.switchPath = switchPath;
    }

    public AbilityData getAbilityData() {
        return this.getData().getAbilityData(this.ability);
    }

    public int getLevel() {
        return this.getAbilityData().getLevel();
    }

    public AbilityData.AbilityTreePath getPath() {
        return this.getAbilityData().getPath();
    }

    public AbilityData.AbilityTreePath getDynamicPath() {
        AbilityData.AbilityTreePath currentPath = this.getPath();
        if (this.switchPath) {
            if (currentPath == AbilityData.AbilityTreePath.FIRST) {
                return AbilityData.AbilityTreePath.SECOND;
            }
            if (currentPath == AbilityData.AbilityTreePath.SECOND) {
                return AbilityData.AbilityTreePath.FIRST;
            }
            return AbilityData.AbilityTreePath.MAIN;
        }
        return currentPath;
    }

    public boolean isMasterLevel(AbilityData.AbilityTreePath path) {
        return this.getLevel() == 3 && this.getPath() == path;
    }

    public boolean isDynamicMasterLevel(AbilityData.AbilityTreePath path) {
        return this.getLevel() == 3 && this.getDynamicPath() == path;
    }

    public double getPowerRating() {
        return this.powerRating;
    }

    public double getPowerRatingDamageMod() {
        return this.getAbilityData().getDamageMult();
    }
}

