/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data.ctx;

import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.util.Vector;
import com.crowsofwar.gorecore.util.VectorI;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class BendingContext {
    private final BendingData data;
    private final Bender bender;
    @Nullable
    private Raytrace.Result raytrace;

    public BendingContext(BendingData data, EntityLivingBase entity, Raytrace.Result raytrace) {
        this.data = data;
        this.bender = Bender.get(entity);
        this.raytrace = raytrace;
        this.verifyClientRaytrace();
    }

    public BendingContext(BendingData data, EntityLivingBase entity, Bender bender, Raytrace.Result raytrace) {
        this.data = data;
        this.bender = bender;
        this.raytrace = raytrace;
        this.verifyClientRaytrace();
    }

    public BendingData getData() {
        return this.data;
    }

    public Bender getBender() {
        return this.bender;
    }

    public EntityLivingBase getBenderEntity() {
        return this.bender.getEntity();
    }

    public World getWorld() {
        return this.bender == null ? null : this.bender.getWorld();
    }

    @Nullable
    public VectorI getLookPosI() {
        if (this.raytrace == null) {
            return null;
        }
        return this.raytrace.getPos();
    }

    @Nullable
    public EnumFacing getLookSide() {
        if (this.raytrace == null) {
            return null;
        }
        return this.raytrace.getSide();
    }

    public boolean isLookingAtBlock() {
        return this.raytrace != null && this.raytrace.hitSomething();
    }

    @Nullable
    public Vector getLookPos() {
        if (this.raytrace == null) {
            return null;
        }
        return this.raytrace.getPosPrecise();
    }

    private void verifyClientRaytrace() {
    }

    public boolean consumeWater(int amount) {
        World world = this.bender.getWorld();
        if (world.func_175727_C(this.bender.getEntity().func_180425_c())) {
            return true;
        }
        EntityLivingBase entity = this.bender.getEntity();
        if (entity.func_184614_ca().func_77973_b() == Items.field_151131_as) {
            entity.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar, 1));
            return true;
        }
        if (entity.func_184592_cb().func_77973_b() == Items.field_151131_as) {
            entity.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Items.field_151133_ar, 1));
            return true;
        }
        VectorI targetPos = this.getLookPosI();
        if (targetPos != null) {
            IBlockState ibs;
            int waterLevel;
            Block lookAt = world.func_180495_p(targetPos.toBlockPos()).func_177230_c();
            if (lookAt == Blocks.field_150355_j || lookAt == Blocks.field_150358_i) {
                if (amount >= 3) {
                    world.func_175698_g(targetPos.toBlockPos());
                }
                return true;
            }
            if (lookAt == Blocks.field_150383_bp && (waterLevel = ((Integer)(ibs = world.func_180495_p(targetPos.toBlockPos())).func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0) {
                world.func_175656_a(targetPos.toBlockPos(), ibs.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(waterLevel - 1)));
                return true;
            }
        }
        return this.bender.consumeWaterLevel(amount);
    }

    public boolean consumeSnow(int amount) {
        Block lookAt;
        World world = this.bender.getWorld();
        if (world.func_175727_C(this.bender.getEntity().func_180425_c())) {
            return true;
        }
        VectorI targetPos = this.getLookPosI();
        if (targetPos != null && ConfigStats.STATS_CONFIG.waterBendableBlocks.contains(lookAt = world.func_180495_p(targetPos.toBlockPos()).func_177230_c())) {
            if (amount >= 3) {
                world.func_175698_g(targetPos.toBlockPos());
            }
            return true;
        }
        return this.bender.consumeWaterLevel(amount);
    }

    public boolean consumePlants(int amount) {
        Block lookAt;
        World world = this.bender.getWorld();
        if (world.func_175727_C(this.bender.getEntity().func_180425_c())) {
            return true;
        }
        VectorI targetPos = this.getLookPosI();
        if (targetPos != null && ConfigStats.STATS_CONFIG.plantBendableBlocks.contains(lookAt = world.func_180495_p(targetPos.toBlockPos()).func_177230_c())) {
            if (amount >= 3) {
                world.func_175698_g(targetPos.toBlockPos());
            }
            return true;
        }
        return this.bender.consumeWaterLevel(amount);
    }
}

