/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data.ctx;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.client.gui.AvatarUiRenderer;
import com.crowsofwar.avatar.config.ConfigChi;
import com.crowsofwar.avatar.entity.EntityLightningArc;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.network.packets.PacketCErrorMessage;
import com.crowsofwar.avatar.network.packets.PacketSUseAbility;
import com.crowsofwar.avatar.registry.AvatarItems;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.analytics.AnalyticEvents;
import com.crowsofwar.avatar.util.analytics.AvatarAnalytics;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BenderInfo;
import com.crowsofwar.avatar.util.data.BenderInfoPlayer;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerBender
extends Bender {
    private final EntityPlayer player;

    public PlayerBender(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public EntityLivingBase getEntity() {
        return this.player;
    }

    @Override
    public BendingData getData() {
        return BendingData.getFromEntity((EntityLivingBase)this.player);
    }

    @Override
    public boolean isCreativeMode() {
        return this.player.field_71075_bZ.field_75098_d;
    }

    @Override
    public boolean isFlying() {
        return this.player.field_71075_bZ.field_75100_b;
    }

    @Override
    public boolean consumeWaterLevel(int amount) {
        ItemStack stack;
        int i;
        int total = 0;
        InventoryPlayer inv = this.player.field_71071_by;
        int inventorySlots = 36;
        for (i = 0; i < inventorySlots; ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != AvatarItems.itemWaterPouch) continue;
            total += stack.func_77960_j();
        }
        if (total >= amount) {
            if (!this.isCreativeMode()) {
                i = 0;
                while (amount > 0) {
                    stack = inv.func_70301_a(i);
                    if (stack.func_77973_b() == AvatarItems.itemWaterPouch) {
                        int oldMetadata = stack.func_77960_j();
                        int newMetadata = stack.func_77960_j() - amount;
                        if (newMetadata < 0) {
                            newMetadata = 0;
                        }
                        amount -= oldMetadata - newMetadata;
                        stack.func_77964_b(newMetadata);
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean consumeChi(float amount) {
        if (this.getEntity().field_70170_p.field_72995_K) {
            return true;
        }
        if (this.isCreativeMode() && ConfigChi.CHI_CONFIG.infiniteInCreative) {
            return true;
        }
        boolean result = this.getData().chi().consumeChi(amount);
        if (!result) {
            this.sendMessage("avatar.nochi");
            AvatarAnalytics.INSTANCE.pushEvent(AnalyticEvents.onOutOfChi());
        }
        return result;
    }

    @Override
    protected boolean canUseAbility(Ability ability) {
        return super.canUseAbility(ability) || this.player.func_184812_l_();
    }

    @Override
    public void sendMessage(String message) {
        if (!this.getWorld().field_72995_K) {
            AvatarMod.network.sendTo((IMessage)new PacketCErrorMessage(message), (EntityPlayerMP)this.player);
        } else {
            AvatarUiRenderer.displayErrorMessage(message);
        }
    }

    @Override
    public void executeAbility(Ability ability, Raytrace.Result raytrace, boolean switchPath) {
        if (this.getWorld().field_72995_K) {
            super.executeAbility(ability, raytrace, switchPath);
            AvatarMod.network.sendToServer((IMessage)new PacketSUseAbility(ability, raytrace, switchPath));
        } else {
            super.executeAbility(ability, raytrace, switchPath);
        }
    }

    @Override
    public BenderInfo getInfo() {
        return new BenderInfoPlayer(this.player.func_70005_c_());
    }

    @Override
    public boolean redirectLightning(EntityLightningArc lightningArc) {
        if (lightningArc.isCreatedByRedirection()) {
            return false;
        }
        EntityLivingBase owner = lightningArc.getOwner();
        BendingData data = this.getData();
        AbilityData abilityData = data.getAbilityData("lightning_redirect");
        if (owner instanceof EntityPlayer && !((EntityPlayer)owner).func_184812_l_() && abilityData.getLevel() == -1) {
            return false;
        }
        if (abilityData.getLevel() == -1 && owner instanceof EntityBender) {
            return false;
        }
        if (!data.hasBendingId(Lightningbending.ID)) {
            return false;
        }
        double chance = abilityData.getLevel() * 10 + 60;
        if (Math.random() * 100.0 < chance) {
            BenderInfo originalShooterInfo = BenderInfo.get(lightningArc.getOwner());
            if (lightningArc.getOwner() != null) {
                data.getMiscData().setRedirectionSource(originalShooterInfo);
                data.addTickHandler(TickHandlerController.LIGHTNING_REDIRECT, new BendingContext(data, (EntityLivingBase)this.player, new Raytrace.Result()));
            }
            String lightningArcOwner = lightningArc.getOwner() == null ? "lightningbender" : lightningArc.getOwner().func_70005_c_();
            AvatarChatMessages.MSG_LIGHTNING_REDIRECT_SUCCESS.send((ICommandSender)this.player, lightningArcOwner);
            return true;
        }
        return false;
    }
}

