/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.helper;

import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.config.ConfigGlider;
import com.crowsofwar.avatar.item.IGlider;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.helper.GliderHelper;
import com.crowsofwar.avatar.util.helper.MathHelper;
import com.crowsofwar.avatar.util.windhelper.WindHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GliderPlayerHelper {
    private static final float FALL_REDUCTION = 0.9f;

    public static void updatePosition(EntityPlayer player) {
        ItemStack glider;
        BendingData data = BendingData.getFromEntity((EntityLivingBase)player);
        boolean isAirbender = false;
        if (data != null) {
            isAirbender = data.getActiveBending() instanceof Airbending;
        }
        if (GliderPlayerHelper.isValidGlider(glider = GliderHelper.getGlider(player))) {
            IGlider iGlider = (IGlider)glider.func_77973_b();
            if (player.func_70613_aW()) {
                if (GliderPlayerHelper.shouldBeGliding(player)) {
                    GliderPlayerHelper.applyHeatUplift(player, iGlider);
                    WindHelper.applyWind(player, glider);
                    if (isAirbender) {
                        float speed = (float)net.minecraft.util.math.MathHelper.func_151238_b((double)iGlider.getMinSpeed(), (double)iGlider.getMaxSpeed(), (double)(-player.field_191988_bg));
                        float elevationBoost = MathHelper.transform(Math.abs(player.field_70125_A), 45.0f, 90.0f, 1.0f, 0.0f);
                        float pitch = -MathHelper.toRadians(player.field_70125_A - iGlider.getPitchOffset() * elevationBoost);
                        float yaw = -MathHelper.toRadians(player.field_70177_z) - (float)Math.PI;
                        float vxz = -net.minecraft.util.math.MathHelper.func_76134_b((float)pitch);
                        float vy = net.minecraft.util.math.MathHelper.func_76126_a((float)pitch);
                        float vz = net.minecraft.util.math.MathHelper.func_76134_b((float)yaw);
                        float vx = net.minecraft.util.math.MathHelper.func_76126_a((float)yaw);
                        player.field_70159_w += (double)(vx * vxz * speed);
                        player.field_70181_x = player.field_70181_x + ((double)(vy * speed) + (double)iGlider.getYBoost() * (player.field_70125_A > 0.0f ? (double)elevationBoost : 1.0));
                        player.field_70179_y += (double)(vz * vxz * speed);
                    } else {
                        if (player.field_70181_x < 0.0) {
                            Vec3d vec3d = player.func_70040_Z();
                            double d0 = 0.5;
                            double d1 = 0.1;
                            player.field_70159_w += vec3d.field_72450_a * d1 + (vec3d.field_72450_a * d0 - player.field_70159_w) * 0.5;
                            player.field_70179_y += vec3d.field_72449_c * d1 + (vec3d.field_72449_c * d0 - player.field_70179_y) * 0.5;
                            player.field_70181_x *= (double)0.9f;
                            player.field_70133_I = true;
                        }
                        player.field_70143_R = 0.0f;
                    }
                }
                if (player.field_70181_x < 0.0) {
                    player.field_70181_x *= (double)iGlider.getFallReduction();
                }
                player.field_70143_R = 0.0f;
            }
        } else {
            GliderHelper.setIsGliderDeployed(player, false);
        }
    }

    private static void applyHeatUplift(EntityPlayer player, IGlider glider) {
        BlockPos pos = player.func_180425_c();
        World worldIn = player.func_130014_f_();
        int maxSearchDown = 15;
        int maxSquared = (maxSearchDown - 1) * (maxSearchDown - 1);
        for (int i = 0; i <= maxSearchDown; ++i) {
            BlockPos scanpos = pos.func_177979_c(i);
            Block scanned = worldIn.func_180495_p(scanpos).func_177230_c();
            if (scanned.equals(Blocks.field_150480_ab) || scanned.equals(Blocks.field_150353_l) || scanned.equals(Blocks.field_150356_k)) {
                double closeness = (maxSearchDown - i) * (maxSearchDown - i);
                double configMovement = 17.2;
                double upUnnormalized = configMovement * closeness;
                double upNormalized = 1.0 + upUnnormalized / (configMovement * (double)maxSquared);
                double motion = player.field_70181_x;
                double scaled = motion - motion * (upNormalized * upNormalized);
                player.field_70181_x += scaled;
                double boostAmt = 1.0 + 0.5 * (double)(maxSearchDown - i);
                double calculated = player.field_70181_x - player.field_70181_x * boostAmt;
                player.field_70181_x += calculated;
                Vec3d vec3d = player.func_70040_Z();
                double d0 = 1.5;
                double d1 = 0.1;
                player.field_70159_w += vec3d.field_72450_a * d1 + (vec3d.field_72450_a * d0 - player.field_70159_w) * 0.2;
                player.field_70179_y += vec3d.field_72449_c * d1 + (vec3d.field_72449_c * d0 - player.field_70179_y) * 0.2;
                double up_boost = i > 0 ? -0.07 * (double)i + 0.6 : 0.07;
                if (!(up_boost > 0.0)) break;
                player.func_70024_g(0.0, up_boost, 0.0);
                if (!ConfigGlider.GLIDER_CONFIG.airResistanceEnabled) break;
                player.field_70159_w *= glider.getAirResistance();
                player.field_70179_y *= glider.getAirResistance();
                break;
            }
            if (!scanned.equals(Blocks.field_150350_a)) break;
        }
    }

    private static void playWindSound(EntityPlayer player) {
        float f = net.minecraft.util.math.MathHelper.func_76133_a((double)(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y + player.field_70181_x * player.field_70181_x));
        float f1 = f / 2.0f;
        float volume = (double)f >= 0.01 ? net.minecraft.util.math.MathHelper.func_76131_a((float)(f1 * f1), (float)0.0f, (float)1.0f) : 0.0f;
        float pitch = volume > 0.8f ? 1.0f + (volume - 0.8f) : 1.0f;
        player.func_184185_a(SoundEvents.field_189426_aK, volume, pitch);
    }

    public static boolean shouldBeGliding(EntityPlayer player) {
        if (player == null || player.field_70128_L) {
            return false;
        }
        return !player.field_70122_E && !player.func_70090_H();
    }

    private static boolean isValidGlider(ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof IGlider && !((IGlider)stack.func_77973_b()).isBroken(stack);
    }

    public static ItemStack getGlider(EntityPlayer player) {
        return player.func_184614_ca();
    }
}

