/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.windhelper;

import com.crowsofwar.avatar.config.ConfigGlider;
import com.crowsofwar.avatar.item.IGlider;
import com.crowsofwar.avatar.util.windhelper.generator.OpenSimplexNoise;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class WindHelper {
    public static OpenSimplexNoise noiseGenerator;

    public static void initNoiseGenerator() {
        noiseGenerator = new OpenSimplexNoise();
    }

    public static void applyWind(EntityPlayer player, ItemStack glider) {
        if (!ConfigGlider.GLIDER_CONFIG.windEnabled) {
            return;
        }
        double windGustSize = ConfigGlider.GLIDER_CONFIG.windGustSize;
        double windFrequency = ConfigGlider.GLIDER_CONFIG.windFrequency;
        double windRainingMultiplier = ConfigGlider.GLIDER_CONFIG.windRainingMultiplier;
        double windSpeedMultiplier = ConfigGlider.GLIDER_CONFIG.windSpeedMultiplier;
        double windHeightMultiplier = ConfigGlider.GLIDER_CONFIG.windHeightMultiplier;
        double windOverallPower = ConfigGlider.GLIDER_CONFIG.windOverallPower;
        double noise = noiseGenerator.eval(player.field_70165_t / windGustSize, player.field_70161_v / windGustSize);
        double d = player.field_70170_p.func_72896_J() ? windRainingMultiplier * windFrequency : windFrequency;
        double velocity = Math.sqrt(Math.pow(player.field_70159_w, 2.0) + Math.pow(player.field_70179_y, 2.0));
        double speedStabilized = (noise *= d) * 1.0 / (velocity * windSpeedMultiplier + 1.0);
        double height = player.field_70163_u < 256.0 ? player.field_70163_u / 256.0 * windHeightMultiplier : windHeightMultiplier;
        double wind = speedStabilized * height;
        double additionalDamagePercentage = glider.func_77951_h() ? (double)ConfigGlider.GLIDER_CONFIG.windDurabilityMultiplier * ((double)glider.func_77952_i() / (double)glider.func_77958_k()) : 0.0;
        wind *= 1.0 + additionalDamagePercentage;
        wind *= windOverallPower;
        player.field_70177_z = (float)((double)player.field_70177_z + (wind *= ((IGlider)glider.func_77973_b()).getWindMultiplier()));
    }
}

