/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.config;

import com.crowsofwar.avatar.snakeyaml.DumperOptions;
import com.crowsofwar.avatar.snakeyaml.Yaml;
import com.crowsofwar.avatar.snakeyaml.error.YAMLException;
import com.crowsofwar.avatar.snakeyaml.nodes.Tag;
import com.crowsofwar.avatar.snakeyaml.representer.Representer;
import com.crowsofwar.avatar.snakeyaml.scanner.ScannerException;
import com.crowsofwar.gorecore.GoreCore;
import com.crowsofwar.gorecore.config.ConfigurationException;
import com.crowsofwar.gorecore.config.CustomObjectLoader;
import com.crowsofwar.gorecore.config.HasCustomLoader;
import com.crowsofwar.gorecore.config.Load;
import com.crowsofwar.gorecore.config.convert.ConverterRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.logging.log4j.Level;

public class ConfigLoader {
    private final String path;
    private final Map<String, ?> data;
    private final Object obj;
    private final Map<String, Object> usedValues;
    private final Representer representer;
    private final List<Class<?>> classTags;
    private final boolean ignoreConfigFile;
    private final boolean neverIgnoreConfig;

    private ConfigLoader(String path, Object obj, Map<String, ?> data, boolean ignoreConfigFile, boolean neverIgnoreConfig) {
        this.path = path;
        this.obj = obj;
        this.data = data == null ? new HashMap() : data;
        this.usedValues = new HashMap<String, Object>();
        this.representer = new Representer();
        this.classTags = new ArrayList();
        this.ignoreConfigFile = ignoreConfigFile;
        this.neverIgnoreConfig = neverIgnoreConfig;
    }

    private void load() {
        Field[] fields;
        for (Field field : fields = this.obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            this.loadField(field);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void loadField(Field field) {
        Class<?> cls = field.getDeclaringClass();
        Class fieldType = field.getType();
        if (fieldType.isPrimitive()) {
            fieldType = ClassUtils.primitiveToWrapper(fieldType);
        }
        try {
            Object setTo;
            boolean tryDefaultValue;
            HasCustomLoader loaderAnnot;
            if (field.getAnnotation(Load.class) == null) return;
            if (Modifier.isStatic(field.getModifiers())) {
                GoreCore.LOGGER.log(Level.WARN, "[ConfigLoader] Warning: Not recommended to mark static fields with @Load, may work out weirdly.");
                GoreCore.LOGGER.log(Level.WARN, "This field is " + field.getDeclaringClass().getName() + "#" + field.getName());
                GoreCore.LOGGER.log(Level.WARN, "Use a singleton instead!");
            }
            CustomLoaderSettings loaderInfo = (loaderAnnot = fieldType.getAnnotation(HasCustomLoader.class)) == null ? new CustomLoaderSettings() : new CustomLoaderSettings(loaderAnnot);
            Object fromData = this.data.get(field.getName());
            boolean bl = tryDefaultValue = fromData == null || this.ignoreConfigFile;
            if (tryDefaultValue) {
                if (field.get(this.obj) == null) throw new ConfigurationException.UserMistake("No configured definition for " + field.getName() + ", no default value");
                setTo = field.get(this.obj);
            } else {
                Class<?> from = fromData.getClass();
                Class to = fieldType;
                setTo = this.convert(fromData, to, field.getName());
            }
            this.usedValues.put(field.getName(), setTo);
            if (!setTo.getClass().getName().startsWith("java")) {
                this.representer.addClassTag(setTo.getClass(), Tag.MAP);
                this.classTags.add(setTo.getClass());
            }
            try {
                if (loaderInfo.hasCustomLoader()) {
                    ((CustomObjectLoader)loaderInfo.customLoaderClass.newInstance()).load(null, setTo);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ConfigurationException.ReflectionException("Couldn't get a loader class of loader " + loaderInfo.customLoaderClass.getName(), e);
            }
            catch (Exception e) {
                throw new ConfigurationException.Unexpected("An unexpected error occurred while using a custom object loader from config. Offending loader is: " + loaderInfo.customLoaderClass, e);
            }
            if (!loaderInfo.loadFields) return;
            field.set(this.obj, setTo);
            return;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException.Unexpected("An unexpected error occurred while loading field \"" + field.getName() + "\" in class \"" + cls.getName() + "\"", e);
        }
    }

    private <T> T convert(Object object, Class<T> to, String name) {
        Class<T> from = object.getClass();
        if (from == to) {
            return (T)object;
        }
        if (from.isAssignableFrom(to) || to.isAssignableFrom(from)) {
            return (T)object;
        }
        if (ConverterRegistry.isConverter(from, to)) {
            return ConverterRegistry.getConverter(from, to).convert(object);
        }
        if (object instanceof Map && !to.isAssignableFrom(Map.class)) {
            T loadedObject;
            try {
                loadedObject = to.newInstance();
                ConfigLoader loader = new ConfigLoader(this.path, loadedObject, (Map)this.data.get(name), this.ignoreConfigFile, this.neverIgnoreConfig);
                loader.load();
                this.usedValues.put(name, loader.dump());
            }
            catch (Exception e) {
                throw new ConfigurationException.ReflectionException("Couldn't get an object of " + to + " with reflection", e);
            }
            return loadedObject;
        }
        throw new ConfigurationException.LoadingException("No way to convert " + from + " -> " + to);
    }

    private String dump() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(this.representer, options);
        try {
            TreeMap<String, Object> sorted = new TreeMap<String, Object>(this.usedValues);
            return yaml.dump(sorted);
        }
        catch (YAMLException e) {
            throw new ConfigurationException.Unexpected("Unexpected error while trying to convert values to YAML: classTags " + this.classTags + ", values " + this.usedValues, e);
        }
    }

    private void save() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File("config/" + this.path)));
            String write = "";
            if (!this.neverIgnoreConfig) {
                if (this.ignoreConfigFile) {
                    write = write + "# WARNING : Any changes to this config file will not take effect!!\n";
                    write = write + "# To fix this, set 'IGNORE_CONFIG_FILE: true' --> 'IGNORE_CONFIG_FILE: false'\n";
                    write = write + "# This was done to prevent default values in new versions from being overriden\n";
                    write = write + "# by outdated config files. By doing this, you will no longer recieve any new\n";
                    write = write + "# config defaults...\n\n";
                }
                write = write + "IGNORE_CONFIG_FILE: " + this.ignoreConfigFile + "\n\n";
            }
            write = write + this.dump();
            write = write.replace("\n", System.getProperty("line.separator"));
            writer.write(write);
            writer.close();
        }
        catch (IOException e) {
            throw new ConfigurationException.LoadingException("Exception while trying to save config file", e);
        }
    }

    private static Map<String, Object> loadMap(String path) {
        try {
            String contents = "";
            File file = new File("config/" + path);
            file.getParentFile().mkdirs();
            file.createNewFile();
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                contents = contents + scanner.nextLine() + "\n";
            }
            scanner.close();
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(contents);
            return map == null ? new HashMap() : map;
        }
        catch (IOException e) {
            throw new ConfigurationException.LoadingException("Exception trying to load config file at " + new File("config/" + path).getAbsolutePath(), e);
        }
        catch (ClassCastException e) {
            System.out.println("ConfigLoader- warning: File at " + path + " was not a map; ignored contents.");
            return new HashMap<String, Object>();
        }
        catch (ScannerException e) {
            throw new ConfigurationException.LoadingException("Malformed YAML file at config/" + path, e);
        }
        catch (Exception e) {
            System.err.println("Error while loading config at 'config/" + path + "':");
            throw e;
        }
    }

    public static void load(Object obj, String path) {
        ConfigLoader.load(obj, path, false);
    }

    public static void load(Object obj, String path, boolean neverIgnoreConfig) {
        Map<String, Object> map = ConfigLoader.loadMap(path);
        boolean ignoreSetting = false;
        if (!neverIgnoreConfig) {
            Object ignoreObject = map.get("IGNORE_CONFIG_FILE");
            ignoreSetting = ignoreObject == null || !(ignoreObject instanceof Boolean) ? true : (Boolean)ignoreObject;
        }
        ConfigLoader loader = new ConfigLoader(path, obj, map, ignoreSetting, neverIgnoreConfig);
        loader.load();
        loader.save();
    }

    public static void save(Object obj, String path) {
        ConfigLoader.save(obj, path, false);
    }

    public static void save(Object obj, String path, boolean neverIgnoreConfig) {
        try {
            Field[] fields;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                if (field.getAnnotation(Load.class) == null) continue;
                field.setAccessible(true);
                map.put(field.getName(), field.get(obj));
            }
            ConfigLoader loader = new ConfigLoader(path, obj, map, false, neverIgnoreConfig);
            loader.usedValues.putAll(map);
            loader.save();
        }
        catch (Exception e) {
            GoreCore.LOGGER.error("Error saving config @ " + path, (Throwable)e);
        }
    }

    private static class CustomLoaderSettings {
        private final Class<? extends CustomObjectLoader> customLoaderClass;
        private final boolean loadFields;

        private CustomLoaderSettings() {
            this.customLoaderClass = null;
            this.loadFields = true;
        }

        private CustomLoaderSettings(HasCustomLoader annot) {
            this.customLoaderClass = annot.loaderClass();
            this.loadFields = annot.loadMarkedFields();
        }

        private boolean hasCustomLoader() {
            return this.customLoaderClass != null;
        }
    }
}

