/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.config;

import com.crowsofwar.avatar.snakeyaml.DumperOptions;
import com.crowsofwar.avatar.snakeyaml.Yaml;
import com.crowsofwar.gorecore.config.ConfigException;
import com.crowsofwar.gorecore.config.UnknownTypeProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class Configuration {
    private Map<String, Object> map;
    private List<Configuration> defaults = new ArrayList<Configuration>();
    private String path;
    private List<Mapping> missingMappings = new ArrayList<Mapping>();

    Configuration(Object obj) {
        if (obj == null) {
            this.map = new HashMap<String, Object>();
        } else if (obj instanceof Map) {
            this.construct((Map)obj);
        } else {
            throw new ConfigException("Config file is not a map");
        }
    }

    private void construct(Map<String, Object> map) {
        this.map = map;
        this.defaults = new ArrayList<Configuration>();
    }

    public UnknownTypeProperty load(String key) {
        if (!this.hasMapping(key)) {
            for (Configuration def : this.defaults) {
                if (!def.hasMapping(key)) continue;
                UnknownTypeProperty property = def.load(key);
                this.missingMappings.add(new Mapping(key, property.getObject()));
                return property;
            }
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        return new UnknownTypeProperty(key, this.map.get(key));
    }

    public boolean hasMapping(String key) {
        return this.map.containsKey(key);
    }

    public Configuration fromMapping(String key) {
        return this.load(key).asMapping();
    }

    public Configuration set(String key, Object val) {
        this.map.put(key, val);
        return this;
    }

    public void save() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.path)));
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        HashMap<String, Object> toDump = new HashMap<String, Object>(this.map);
        for (Mapping mapping : this.missingMappings) {
            toDump.put(mapping.key, mapping.value);
        }
        String asText = "";
        Yaml yaml = new Yaml(options);
        asText = yaml.dump(toDump);
        writer.write(asText);
        writer.close();
    }

    public Configuration withDefaults(String path) {
        try {
            String text = "";
            InputStream instr = this.getClass().getClassLoader().getResourceAsStream(path);
            if (instr == null) {
                throw new FileNotFoundException("Default configuration file not found: " + path);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(instr, StandardCharsets.UTF_8));
            String ln = null;
            while ((ln = br.readLine()) != null) {
                text = text + ln + "\n";
            }
            br.close();
            Yaml yaml = new Yaml();
            Object loaded = yaml.load(text);
            if (loaded != null) {
                this.defaults.add(new Configuration(loaded));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public static Configuration from(String path) {
        try {
            String contents = "";
            File file = new File("config/" + path);
            file.createNewFile();
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                contents = contents + scanner.nextLine() + "\n";
            }
            scanner.close();
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(contents);
            Configuration config = new Configuration(map);
            config.path = "config/" + path;
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class Mapping {
        private final String key;
        private final Object value;

        public Mapping(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

