/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.config;

import com.crowsofwar.gorecore.config.Animal;
import com.crowsofwar.gorecore.config.ConfigLoader;
import com.crowsofwar.gorecore.config.Load;
import com.crowsofwar.gorecore.config.convert.Converter;
import com.crowsofwar.gorecore.config.convert.ConverterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SampleConfiguration {
    @Load
    private int settingA;
    @Load
    public double settingB;
    public Animal bob;
    @Load
    public Animal fluffy = new Animal("Fluffers", "Fluff ball", 4, true);
    public Animal notSoFluffy;
    @Load
    public List<String> people = new ArrayList<String>();
    @Load
    public static Rock rockA = new Rock(3);
    @Load
    public Rock rockB = new Rock(5);
    @Load
    public HandHoldingRock hand = new HandHoldingRock(this.rockB);

    public static void main(String[] args) {
        ConverterRegistry.addDefaultConverters();
        SampleConfiguration cfg = new SampleConfiguration();
        ConfigLoader.load(cfg, "annot-test.cfg");
        System.out.println("Fluffy: " + cfg.fluffy);
        System.out.println("People: " + cfg.people);
    }

    private static <T> Converter<T, Set> findConverter(T obj) {
        return ConverterRegistry.getConverter(obj.getClass(), Set.class);
    }

    public static class HandHoldingRock {
        @Load
        public Rock myRock;

        public HandHoldingRock() {
        }

        public HandHoldingRock(Rock rock) {
            this.myRock = rock;
        }
    }

    public static class Rock {
        @Load
        public int size;

        public Rock() {
        }

        public Rock(int size) {
            this.size = size;
        }
    }
}

