/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.config;

import com.crowsofwar.gorecore.config.ConfigException;
import com.crowsofwar.gorecore.config.Configuration;
import com.crowsofwar.gorecore.config.ListLoader;
import com.crowsofwar.gorecore.config.ObjectLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnknownTypeProperty {
    private final Object object;
    private final String name;

    public UnknownTypeProperty(String name, Object obj) {
        this.name = name;
        this.object = obj;
    }

    public Object getObject() {
        return this.object;
    }

    public <T> T as(ObjectLoader<T> factory) {
        if (!(this.object instanceof Map)) {
            throw new ConfigException(this.name + " isn't a Dictionary");
        }
        return factory.load(new Configuration(this.object));
    }

    public String asString() {
        return this.object.toString();
    }

    public int asInt() {
        try {
            return Integer.valueOf(this.object + "");
        }
        catch (NumberFormatException e) {
            throw new ConfigException(this.name + " isn't an integer");
        }
    }

    public boolean asBoolean() {
        try {
            return (Boolean)this.object;
        }
        catch (ClassCastException e) {
            throw new ConfigException(this.name + " isn't a boolean");
        }
    }

    public double asDouble() {
        try {
            return Double.valueOf(this.object + "");
        }
        catch (NumberFormatException e) {
            throw new ConfigException(this.name + " isn't a double");
        }
    }

    public <T> List<T> asList(ListLoader<T> factory) {
        if (!(this.object instanceof List)) {
            throw new ConfigException(this.name + " isn't a List");
        }
        ArrayList<T> out = new ArrayList<T>();
        List list = (List)this.object;
        for (Object obj : list) {
            out.add(factory.load(obj));
        }
        return out;
    }

    public List<String> asStringList() {
        return this.asList(obj -> (String)obj);
    }

    public Configuration asMapping() {
        return new Configuration(this.object);
    }
}

