/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.config.convert;

import com.crowsofwar.gorecore.config.convert.Converter;
import com.crowsofwar.gorecore.config.convert.Pair;
import java.util.HashMap;
import java.util.Map;

public class ConverterRegistry {
    private static final Map<Pair, Converter> converters = new HashMap<Pair, Converter>();

    public static <F, T> void addConverter(Class<F> from, Class<T> to, Converter<F, T> convert) {
        Pair pair = Pair.of(from, to);
        converters.put(pair, convert);
    }

    public static <F, T> Converter<F, T> getConverter(Class<F> from, Class<T> to) {
        Pair pair = Pair.of(from, to);
        return converters.get(pair);
    }

    public static boolean isConverter(Class<?> from, Class<?> to) {
        if (!Pair.exists(from, to)) {
            return false;
        }
        Pair pair = Pair.of(from, to);
        return converters.containsKey(pair);
    }

    public static void addDefaultConverters() {
        ConverterRegistry.addConverter(Integer.class, Double.class, integer -> integer.doubleValue());
        ConverterRegistry.addConverter(Double.class, Integer.class, dubbl -> dubbl.intValue());
        ConverterRegistry.addConverter(Integer.class, String.class, integer -> integer + "");
        ConverterRegistry.addConverter(Double.class, String.class, dubbl -> dubbl + "");
        ConverterRegistry.addConverter(Integer.class, Float.class, integer -> Float.valueOf(integer.floatValue()));
        ConverterRegistry.addConverter(Float.class, Integer.class, floatt -> floatt.intValue());
        ConverterRegistry.addConverter(Double.class, Float.class, dubbl -> Float.valueOf(dubbl.floatValue()));
        ConverterRegistry.addConverter(Float.class, Double.class, floatt -> floatt.doubleValue());
    }
}

