/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.config.convert;

import com.crowsofwar.gorecore.config.convert.ConversionException;
import com.crowsofwar.gorecore.config.convert.Type;

public class Pair {
    private final Type typeA;
    private final Type typeB;

    private Pair(Type typeA, Type typeB) {
        this.typeA = typeA;
        this.typeB = typeB;
    }

    public static Pair of(Class<?> clsA, Class<?> clsB) {
        if (clsA == null || clsB == null) {
            throw new ConversionException("Cannot get a pair with a null class");
        }
        return new Pair(Type.of(clsA), Type.of(clsB));
    }

    public static boolean exists(Class<?> clsA, Class<?> clsB) {
        return Type.exists(clsA) && Type.exists(clsB);
    }

    public int hashCode() {
        return this.typeA.id() + this.typeB.id();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)obj;
        return pair.typeA == this.typeA && pair.typeB == this.typeB;
    }
}

