/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.config.convert;

import com.crowsofwar.gorecore.config.Animal;
import com.crowsofwar.gorecore.config.convert.ConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum Type {
    ERROR(null),
    INTEGER(Integer.class),
    DOUBLE(Double.class),
    LIST(List.class),
    SET(Set.class),
    ANIMAL(Animal.class),
    STRING(String.class),
    FLOAT(Float.class);

    private static final Map<Class<?>, Type> classToType;
    private final Class<?> cls;

    private Type(Class<?> cls) {
        this.cls = cls;
    }

    public int id() {
        return (int)Math.pow(2.0, this.ordinal() - 1);
    }

    public static Type of(Class<?> cls) {
        if (!classToType.containsKey(cls)) {
            ArrayList supers = new ArrayList(Arrays.asList(cls.getInterfaces()));
            supers.addAll(Type.allSuperclasses(cls));
            for (Class clazz : supers) {
                if (!classToType.containsKey(clazz)) continue;
                return classToType.get(clazz);
            }
            throw new ConversionException("No type for class " + cls);
        }
        return classToType.get(cls);
    }

    public static boolean exists(Class<?> cls) {
        if (!classToType.containsKey(cls)) {
            ArrayList supers = new ArrayList(Arrays.asList(cls.getInterfaces()));
            supers.addAll(Type.allSuperclasses(cls));
            for (Class clazz : supers) {
                if (!classToType.containsKey(clazz)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static List<Class> allSuperclasses(Class<?> cls) {
        ArrayList<Class> out = new ArrayList<Class>();
        Class<?> sup = cls;
        while ((sup = sup.getSuperclass()) != Object.class) {
            out.add(sup);
        }
        return out;
    }

    static {
        classToType = new HashMap();
        for (Type t : Type.values()) {
            classToType.put(t.cls, t);
        }
    }
}

