/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.data;

import com.crowsofwar.gorecore.data.DataSaver;
import com.crowsofwar.gorecore.util.GoreCoreNBTInterfaces;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

public abstract class PlayerData
implements GoreCoreNBTInterfaces.ReadableWritable {
    public static final GoreCoreNBTInterfaces.MapUser<UUID, PlayerData> MAP_USER = new GoreCoreNBTInterfaces.MapUser<UUID, PlayerData>(){

        @Override
        public UUID createK(NBTTagCompound nbt, Object[] constructArgsK) {
            return GoreCoreNBTUtil.readUUIDFromNBT(nbt, "KeyUUID");
        }

        @Override
        public PlayerData createV(NBTTagCompound nbt, UUID key, Object[] constructArgsV) {
            try {
                PlayerData data = (PlayerData)((Class)constructArgsV[0]).getConstructor(DataSaver.class, UUID.class, EntityPlayer.class).newInstance(constructArgsV[1], key, null);
                data.readFromNBT(nbt);
                return data;
            }
            catch (Exception e) {
                FMLLog.severe((String)"GoreCore> An error occured while creating new player data!", (Object[])new Object[0]);
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void writeK(NBTTagCompound nbt, UUID obj) {
            GoreCoreNBTUtil.writeUUIDToNBT(nbt, "KeyUUID", obj);
        }

        @Override
        public void writeV(NBTTagCompound nbt, PlayerData obj) {
            obj.writeToNBT(nbt);
        }
    };
    protected UUID playerID;
    protected DataSaver dataSaver;
    private EntityPlayer playerEntity;

    public PlayerData(DataSaver dataSaver, UUID playerID, EntityPlayer playerEntity) {
        this.construct(dataSaver, playerID, playerEntity);
    }

    public String toString() {
        return "PlayerData(playerId = " + this.playerID + ", dataSaver = " + this.dataSaver + ")";
    }

    protected void construct(DataSaver dataSaver, UUID playerID, EntityPlayer playerEntity) {
        if (dataSaver == null) {
            FMLLog.severe((String)"GoreCore> Player data was created with a null dataSaver - this is a bug! Debug:", (Object[])new Object[0]);
        }
        if (playerID == null) {
            FMLLog.severe((String)"GoreCore> Player data was created with a null playerID - this is a bug! Debug:", (Object[])new Object[0]);
        }
        if (dataSaver == null || playerID == null) {
            Thread.dumpStack();
        }
        this.dataSaver = dataSaver;
        this.playerID = playerID;
        this.playerEntity = playerEntity;
    }

    protected void saveChanges() {
        this.dataSaver.saveChanges();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.playerID = GoreCoreNBTUtil.readUUIDFromNBT(nbt, "PlayerID");
        this.readPlayerDataFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        GoreCoreNBTUtil.writeUUIDToNBT(nbt, "PlayerID", this.playerID);
        this.writePlayerDataToNBT(nbt);
    }

    protected abstract void readPlayerDataFromNBT(NBTTagCompound var1);

    protected abstract void writePlayerDataToNBT(NBTTagCompound var1);

    public UUID getPlayerID() {
        return this.playerID;
    }

    public boolean shouldBeDecached() {
        return this.playerEntity.field_70128_L;
    }

    public EntityPlayer getPlayerEntity() {
        return this.playerEntity;
    }

    public void setPlayerEntity(EntityPlayer player) {
        this.playerEntity = player;
    }

    public World getWorld() {
        return this.getPlayerEntity() == null ? null : this.getPlayerEntity().func_130014_f_();
    }
}

