/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.data;

import com.crowsofwar.gorecore.data.PlayerData;
import com.crowsofwar.gorecore.util.AccountUUIDs;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public interface PlayerDataFetcher<T extends PlayerData> {
    public T fetch(World var1, UUID var2);

    default public T fetch(World world, String playerName) {
        if (world == null) {
            throw new IllegalArgumentException("Cannot get player-data with null World");
        }
        if (playerName == null) {
            throw new IllegalArgumentException("Cannot get player-data with null player name");
        }
        return this.fetch(world, AccountUUIDs.getId(playerName));
    }

    default public T fetch(EntityPlayer player) {
        if (player == null) {
            throw new IllegalArgumentException("Cannot get Player-Data for null player");
        }
        return this.fetch(player.field_70170_p, player.func_70005_c_());
    }
}

