/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.data;

import com.crowsofwar.gorecore.GoreCore;
import com.crowsofwar.gorecore.data.DataSaver;
import com.crowsofwar.gorecore.data.DataSaverDontSave;
import com.crowsofwar.gorecore.data.PlayerData;
import com.crowsofwar.gorecore.data.PlayerDataFetcher;
import com.crowsofwar.gorecore.util.AccountUUIDs;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerDataFetcherClient<T extends PlayerData>
implements PlayerDataFetcher<T> {
    private final Minecraft mc;
    private Map<UUID, T> playerData = new HashMap<UUID, T>();
    private Class<T> dataClass;
    private Consumer<T> onCreate;
    private int ticksUntilCheck;

    public PlayerDataFetcherClient(Class<T> dataClass) {
        this(dataClass, t -> {});
    }

    public PlayerDataFetcherClient(Class<T> dataClass, Consumer<T> callback) {
        this.mc = Minecraft.func_71410_x();
        this.dataClass = dataClass;
        this.onCreate = callback;
        this.ticksUntilCheck = 20;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private T createPlayerData(Class<T> dataClass, UUID playerID) {
        try {
            EntityPlayer player = AccountUUIDs.findEntityFromUUID((World)this.mc.field_71441_e, playerID);
            return (T)((PlayerData)dataClass.getConstructor(DataSaver.class, UUID.class, EntityPlayer.class).newInstance(new DataSaverDontSave(), playerID, player));
        }
        catch (Exception e) {
            GoreCore.LOGGER.warn("Found an error when trying to make new client-side player data!");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public T fetch(World world, UUID playerID) {
        if (world == null) {
            throw new IllegalArgumentException("Cannot get client player data for null world");
        }
        if (playerID == null) {
            throw new IllegalArgumentException("Cannot get client player data for null player ID");
        }
        PlayerData data = (PlayerData)this.playerData.get(playerID);
        if (data == null) {
            data = this.createPlayerData(this.dataClass, playerID);
            this.playerData.put(playerID, data);
            if (this.onCreate != null) {
                this.onCreate.accept(data);
            }
        }
        data.setPlayerEntity(AccountUUIDs.findEntityFromUUID(world, playerID));
        return (T)data;
    }

    @SubscribeEvent
    public void onUnloadWorld(WorldEvent.Unload e) {
        this.playerData.clear();
        GoreCore.LOGGER.info("Client fetcher- all player data decached");
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.side == Side.CLIENT && e.phase == TickEvent.Phase.START && --this.ticksUntilCheck == 0) {
            this.ticksUntilCheck = 20;
            Iterator<UUID> iterator = this.playerData.keySet().iterator();
            while (iterator.hasNext()) {
                UUID playerId = iterator.next();
                PlayerData data = (PlayerData)this.playerData.get(playerId);
                if (!data.shouldBeDecached()) continue;
                GoreCore.LOGGER.info("Client fetcher- decaching some player data");
                iterator.remove();
            }
        }
    }
}

