/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.data;

import com.crowsofwar.gorecore.data.PlayerData;
import com.crowsofwar.gorecore.data.PlayerDataFetcher;
import com.crowsofwar.gorecore.data.WorldDataPlayers;
import com.crowsofwar.gorecore.util.AccountUUIDs;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.World;

public class PlayerDataFetcherServer<T extends PlayerData>
implements PlayerDataFetcher<T> {
    private final Function<World, WorldDataPlayers<T>> worldDataFetcher;

    public PlayerDataFetcherServer(Function<World, WorldDataPlayers<T>> worldDataFetcher) {
        this.worldDataFetcher = worldDataFetcher;
    }

    @Override
    public T fetch(World world, UUID accountId) {
        if (world == null) {
            throw new IllegalArgumentException("Cannot get client player data for null world");
        }
        if (accountId == null) {
            throw new IllegalArgumentException("Cannot get client player data for null player ID");
        }
        T data = this.worldDataFetcher.apply(world).getPlayerData(accountId);
        ((PlayerData)data).setPlayerEntity(AccountUUIDs.findEntityFromUUID(world, accountId));
        return data;
    }
}

