/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.data;

import com.crowsofwar.gorecore.data.DataSaver;
import com.crowsofwar.gorecore.data.DataSaverNBT;
import java.util.Objects;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLLog;

public abstract class WorldData
extends WorldSavedData
implements DataSaver {
    private World world;
    private DataSaverNBT storedData = new DataSaverNBT();

    public WorldData(String key) {
        super(key);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    @Override
    public void saveChanges() {
        this.func_76185_a();
    }

    protected static <T extends WorldData> T getDataForWorld(Class<T> worldDataClass, String key, World world, boolean separatePerDimension) {
        try {
            MapStorage ms = separatePerDimension ? world.getPerWorldStorage() : world.func_175693_T();
            WorldData data = (WorldData)worldDataClass.cast(Objects.requireNonNull(ms).func_75742_a(worldDataClass, key));
            if (data == null) {
                data = (WorldData)worldDataClass.getConstructor(String.class).newInstance(key);
                data.func_76186_a(true);
                ms.func_75745_a(key, (WorldSavedData)data);
            }
            data.setWorld(world);
            return (T)data;
        }
        catch (Exception e) {
            FMLLog.bigWarning((String)"GoreCore> Could not get World Data class!", (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getInt(String key) {
        return this.storedData.getInt(key);
    }

    @Override
    public void setInt(String key, int value) {
        this.storedData.setInt(key, value);
    }

    @Override
    public String getString(String key) {
        return this.storedData.getString(key);
    }

    @Override
    public void setString(String key, String value) {
        this.storedData.setString(key, value);
    }

    @Override
    public float getFloat(String key) {
        return this.storedData.getFloat(key);
    }

    @Override
    public void setFloat(String key, float value) {
        this.storedData.setFloat(key, value);
    }

    @Override
    public double getDouble(String key) {
        return this.storedData.getDouble(key);
    }

    @Override
    public void setDouble(String key, double value) {
        this.storedData.setDouble(key, value);
    }

    @Override
    public long getLong(String key) {
        return this.storedData.getLong(key);
    }

    @Override
    public void setLong(String key, long value) {
        this.storedData.setLong(key, value);
    }
}

