/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.data;

import com.crowsofwar.gorecore.GoreCore;
import com.crowsofwar.gorecore.data.DataSaver;
import com.crowsofwar.gorecore.data.PlayerData;
import com.crowsofwar.gorecore.data.WorldData;
import com.crowsofwar.gorecore.util.AccountUUIDs;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;

public abstract class WorldDataPlayers<T extends PlayerData>
extends WorldData {
    private Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

    public WorldDataPlayers(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.players = GoreCoreNBTUtil.readMapFromNBT(nbt, PlayerData.MAP_USER, "PlayerData", new Object[0], new Object[]{this.playerDataClass(), this});
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        GoreCoreNBTUtil.writeMapToNBT(nbt, this.players, PlayerData.MAP_USER, "PlayerData");
        return nbt;
    }

    public T getPlayerData(UUID player) {
        Objects.requireNonNull(player, "Tried to create data for null player");
        Objects.requireNonNull(this.getWorld(), "Tried to create data for null world");
        T data = this.getPlayerDataWithoutCreate(player);
        if (data == null) {
            data = this.createNewPlayerData(player);
            this.players.put(player, (PlayerData)data);
            ((PlayerData)data).setPlayerEntity(AccountUUIDs.findEntityFromUUID(this.getWorld(), player));
            this.saveChanges();
        }
        Objects.requireNonNull(data, String.format("Couldn't create data for player \"%s\" and world \"%s\"!", player, this.getWorld().field_73011_w.func_186058_p().func_186065_b()));
        return data;
    }

    public T getPlayerDataWithoutCreate(UUID player) {
        PlayerData data = this.players.get(player);
        if (data != null && data.getPlayerEntity() == null) {
            data.setPlayerEntity(AccountUUIDs.findEntityFromUUID(this.getWorld(), player));
        }
        return (T)data;
    }

    public abstract Class<T> playerDataClass();

    private T createNewPlayerData(UUID player) {
        try {
            EntityPlayer playerEntity = AccountUUIDs.findEntityFromUUID(this.getWorld(), player);
            if (playerEntity == null) {
                GoreCore.LOGGER.warn("WARNING: playerEntity was null while creating new player data");
            }
            PlayerData data = (PlayerData)this.playerDataClass().getConstructor(DataSaver.class, UUID.class, EntityPlayer.class).newInstance(this, player, playerEntity);
            return (T)data;
        }
        catch (Exception e) {
            FMLLog.warning((String)"GoreCore> Found an error when trying to make new player data!", (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }
}

