/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.format;

import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.format.FormattedMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChatSender {
    public static final ChatSender instance = new ChatSender();
    private static final Map<String, FormattedMessage> referenceToChatMessage;
    static final Map<String, FormattedMessage> translateKeyToChatMessage;

    public static void load() {
    }

    private ChatSender() {
    }

    private Object[] getFormatArgs(TextComponentTranslation message) {
        return (Object[])ObfuscationReflectionHelper.getPrivateValue(TextComponentTranslation.class, (Object)message, (int)1);
    }

    private String getKey(TextComponentTranslation message) {
        return (String)ObfuscationReflectionHelper.getPrivateValue(TextComponentTranslation.class, (Object)message, (int)0);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void processClientChat(ClientChatReceivedEvent e) {
        if (e.getMessage() instanceof TextComponentTranslation) {
            TextComponentTranslation message = (TextComponentTranslation)e.getMessage();
            ArrayList<TextComponentTranslation> comps = new ArrayList<TextComponentTranslation>();
            Object[] formatArgs = this.getFormatArgs(message);
            comps.add(new TextComponentTranslation(this.getKey(message), formatArgs));
            comps.addAll(e.getMessage().func_150253_a());
            String result = "";
            for (ITextComponent iTextComponent : comps) {
                String processed = this.formatChatComponent(iTextComponent, false);
                if (processed == null) continue;
                result = result + processed;
            }
            if (!result.isEmpty()) {
                e.setMessage((ITextComponent)new TextComponentTranslation(result, new Object[0]));
            }
        }
    }

    private String formatChatComponent(ITextComponent chat, boolean plaintext) {
        TextComponentTranslation translate;
        String key;
        FormattedMessage cm;
        if (chat instanceof TextComponentTranslation && (cm = translateKeyToChatMessage.get(key = this.getKey(translate = (TextComponentTranslation)chat))) != null) {
            try {
                String text = translate.func_150260_c().replaceAll("%", "%%");
                if (plaintext) {
                    return FormattedMessageProcessor.formatPlaintext(cm, text, translate.func_150271_j());
                }
                return FormattedMessageProcessor.formatText(cm, text, translate.func_150271_j());
            }
            catch (ProcessingException e) {
                e.printStackTrace();
                return "Error processing text; see log for details";
            }
        }
        return null;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        referenceToChatMessage = new HashMap<String, FormattedMessage>();
        translateKeyToChatMessage = new HashMap<String, FormattedMessage>();
    }

    static class ProcessingException
    extends RuntimeException {
        public ProcessingException(String message) {
            super(message);
        }
    }
}

