/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.format;

import com.crowsofwar.gorecore.GoreCore;
import com.crowsofwar.gorecore.format.ChatSender;
import com.crowsofwar.gorecore.format.FormattedMessageProcessor;
import com.crowsofwar.gorecore.format.MessageConfiguration;
import com.crowsofwar.gorecore.format.MultiMessage;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;

public class FormattedMessage {
    private final String translateKey;
    private final String[] translateArgs;
    private final MessageConfiguration config;

    private FormattedMessage(MessageConfiguration config, String translateKey, String ... translateArgs) {
        this.translateKey = translateKey;
        this.translateArgs = translateArgs;
        this.config = config;
    }

    public ITextComponent getChatMessage(boolean plaintext, Object ... formatValues) {
        if (plaintext) {
            String unformatted = I18n.func_74838_a((String)this.translateKey);
            String formatted = FormattedMessageProcessor.formatPlaintext(this, unformatted, formatValues);
            return new TextComponentString(formatted);
        }
        return new TextComponentTranslation(this.translateKey, formatValues);
    }

    public void send(ICommandSender sender, Object ... formatValues) {
        if (GoreCore.spongeCompat) {
            sender.func_145747_a(this.getChatMessage(true, formatValues));
        } else {
            sender.func_145747_a(this.getChatMessage(!(sender instanceof Entity), formatValues));
        }
    }

    public String getTranslateKey() {
        return this.translateKey;
    }

    public String[] getTranslationArgs() {
        return this.translateArgs;
    }

    public MultiMessage chain() {
        return new MultiMessage().add(this, new Object[0]);
    }

    public MessageConfiguration getConfig() {
        return this.config;
    }

    public static FormattedMessage newChatMessage(String translateKey, String ... translateArgs) {
        return FormattedMessage.newChatMessage(MessageConfiguration.DEFAULT, translateKey, translateArgs);
    }

    public static FormattedMessage newChatMessage(MessageConfiguration config, String translateKey, String ... translateArgs) {
        FormattedMessage cm = new FormattedMessage(config, translateKey, translateArgs);
        ChatSender.translateKeyToChatMessage.put(translateKey, cm);
        return cm;
    }
}

