/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.format;

import com.crowsofwar.gorecore.GoreCore;
import com.crowsofwar.gorecore.format.ChatSender;
import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.format.MessageConfiguration;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.TextFormatting;

public class FormattedMessageProcessor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatText(FormattedMessage msg, String text, Object ... formatValues) {
        MessageConfiguration cfg = msg.getConfig();
        String[] translateArgs = msg.getTranslationArgs();
        for (int i = 0; i < translateArgs.length; ++i) {
            text = text.replace("${" + translateArgs[i] + "}", formatValues[i].toString());
        }
        Set<Map.Entry<String, String>> consts = cfg.getAllConstants();
        for (Map.Entry<String, String> entry : consts) {
            text = text.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        FormattingState format = new FormattingState();
        String newText = "";
        Matcher matcher = Pattern.compile("\\\\?\\[?\\/?[^\\]\\[\\\\]+\\]?").matcher(text);
        while (matcher.find()) {
            String item = matcher.group();
            boolean refreshFormatting = false;
            if (item.equals("")) continue;
            if (item.startsWith("[") && item.endsWith("]")) {
                String key;
                String tag = item.substring(1, item.length() - 1);
                if (tag.equals("bold")) {
                    format.pushFormat(new ChatFormat("bold").setBold(FormatSetting.TRUE));
                    refreshFormatting = true;
                } else if (tag.equals("italic")) {
                    format.pushFormat(new ChatFormat("italic").setItalic(FormatSetting.TRUE));
                    refreshFormatting = true;
                } else if (FormattedMessageProcessor.getTfColor(tag) != null) {
                    format.pushFormat(new ChatFormat(tag).setColor(FormattedMessageProcessor.getTfColor(tag)));
                    refreshFormatting = true;
                } else if (cfg.getColor(tag) != null) {
                    format.pushFormat(new ChatFormat(tag).setColor(cfg.getColor(tag)));
                    refreshFormatting = true;
                } else if (tag.startsWith("/")) {
                    if (!tag.substring(1).equals(format.topFormat().name)) throw new ChatSender.ProcessingException("Error processing message; closing tag does not match last opened tag: [" + tag.substring(1) + "]; text is: " + text);
                    format.popFormat();
                    refreshFormatting = true;
                } else if (tag.startsWith("translate=")) {
                    key = tag.substring("translate=".length());
                    item = FormattedMessageProcessor.formatText(msg, GoreCore.proxy.translate(key, new Object[0]), formatValues);
                } else {
                    if (!tag.startsWith("keybinding=")) throw new ChatSender.ProcessingException("String has invalid tag: [" + tag + "]; text is " + text);
                    key = tag.substring("keybinding=".length());
                    item = GoreCore.proxy.getKeybindingDisplayName(key);
                }
            }
            if (item.startsWith("\\[") && item.endsWith("]")) {
                item = item.substring(1);
            }
            if (refreshFormatting) {
                newText = newText + format.apply();
                continue;
            }
            newText = newText + item;
        }
        if (!format.hasFormat()) return newText;
        throw new ChatSender.ProcessingException("Unclosed tag [" + format.topFormat().name + "] in text " + text);
    }

    public static String formatPlaintext(FormattedMessage msg, String text, Object ... formatValues) {
        MessageConfiguration cfg = msg.getConfig();
        String[] translateArgs = msg.getTranslationArgs();
        for (int i = 0; i < translateArgs.length; ++i) {
            text = text.replace("${" + translateArgs[i] + "}", formatValues[i].toString());
        }
        Set<Map.Entry<String, String>> consts = cfg.getAllConstants();
        for (Map.Entry<String, String> entry : consts) {
            text = text.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        String newText = "";
        Matcher matcher = Pattern.compile("\\\\?\\[?\\/?[^\\]\\[\\\\]+\\]?").matcher(text);
        while (matcher.find()) {
            String item = matcher.group();
            boolean formattingTag = false;
            if (item.equals("")) continue;
            if (item.startsWith("[") && item.endsWith("]")) {
                String key;
                String tag = item.substring(1, item.length() - 1);
                if (tag.startsWith("translate=")) {
                    key = tag.substring("translate=".length());
                    item = FormattedMessageProcessor.formatPlaintext(msg, GoreCore.proxy.translate(key, new Object[0]), formatValues);
                } else if (tag.startsWith("keybinding=")) {
                    key = tag.substring("keybinding=".length());
                    item = GoreCore.proxy.getKeybindingDisplayName(key);
                } else if (tag.equals("bold") || tag.equals("italic") || FormattedMessageProcessor.getTfColor(tag) != null || cfg.hasColor(tag) || tag.startsWith("/")) {
                    formattingTag = true;
                } else {
                    throw new ChatSender.ProcessingException("String has invalid tag: [" + tag + "]; text is " + text);
                }
            }
            if (item.startsWith("\\[") && item.endsWith("]")) {
                item = item.substring(1);
            }
            if (formattingTag) continue;
            newText = newText + item;
        }
        return newText;
    }

    private static TextFormatting getTfColor(String name) {
        for (TextFormatting tf : TextFormatting.values()) {
            if (!tf.func_96302_c() || !tf.name().toLowerCase().equals(name)) continue;
            return tf;
        }
        return null;
    }

    public static enum FormatSetting {
        UNAFFECTED,
        TRUE,
        FALSE;


        public boolean value() {
            return this == TRUE;
        }

        public boolean isUnknown() {
            return this == UNAFFECTED;
        }
    }

    private static class ChatFormat {
        private final String name;
        private FormatSetting bold;
        private FormatSetting italic;
        private TextFormatting color;

        private ChatFormat(String name) {
            this.name = name;
            this.bold = FormatSetting.UNAFFECTED;
            this.italic = FormatSetting.UNAFFECTED;
            this.color = null;
        }

        public ChatFormat setBold(FormatSetting bold) {
            this.bold = bold;
            return this;
        }

        public ChatFormat setItalic(FormatSetting italic) {
            this.italic = italic;
            return this;
        }

        public ChatFormat setColor(TextFormatting color) {
            this.color = color;
            return this;
        }
    }

    private static class FormattingState {
        private final Stack<ChatFormat> formats = new Stack();

        public void pushFormat(ChatFormat format) {
            this.formats.push(format);
        }

        public void popFormat() {
            this.formats.pop();
        }

        public ChatFormat topFormat() {
            return this.formats.peek();
        }

        public boolean hasFormat() {
            return !this.formats.isEmpty();
        }

        public boolean isBold() {
            boolean bold = false;
            for (int i = 0; i < this.formats.size(); ++i) {
                ChatFormat format = (ChatFormat)this.formats.get(i);
                if (format.bold.isUnknown()) continue;
                bold = format.bold.value();
            }
            return bold;
        }

        public boolean isItalic() {
            boolean italic = false;
            for (int i = 0; i < this.formats.size(); ++i) {
                ChatFormat format = (ChatFormat)this.formats.get(i);
                if (format.italic.isUnknown()) continue;
                italic = format.italic.value();
            }
            return italic;
        }

        public TextFormatting getColor() {
            TextFormatting color = TextFormatting.WHITE;
            for (int i = 0; i < this.formats.size(); ++i) {
                ChatFormat format = (ChatFormat)this.formats.get(i);
                if (format.color == null) continue;
                color = format.color;
            }
            return color;
        }

        public String apply() {
            String result = TextFormatting.RESET.toString();
            result = result + this.getColor().toString();
            if (this.isBold()) {
                result = result + TextFormatting.BOLD.toString();
            }
            if (this.isItalic()) {
                result = result + TextFormatting.ITALIC.toString();
            }
            return result;
        }

        public String toString() {
            return "FormattingState " + this.formats;
        }
    }
}

