/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.text.TextFormatting;

public class MessageConfiguration {
    public static final MessageConfiguration DEFAULT = new MessageConfiguration();
    private final Map<String, TextFormatting> colors = new HashMap<String, TextFormatting>();
    private final Map<String, String> constants = new HashMap<String, String>();

    public MessageConfiguration addColor(String reference, TextFormatting color) {
        if (!color.func_96302_c()) {
            throw new IllegalArgumentException("The chat formatting must be a color");
        }
        this.colors.put(reference, color);
        return this;
    }

    public TextFormatting getColor(String reference) {
        return this.colors.get(reference);
    }

    public String getColorName(String reference) {
        if (this.hasColor(reference)) {
            return this.getColor(reference).name().toLowerCase();
        }
        return null;
    }

    public boolean hasColor(String reference) {
        return this.colors.containsKey(reference);
    }

    public Map<String, TextFormatting> allColors() {
        return new HashMap<String, TextFormatting>(this.colors);
    }

    public MessageConfiguration addConstant(String name, String value) {
        this.constants.put(name, value);
        return this;
    }

    public Set<Map.Entry<String, String>> getAllConstants() {
        return Collections.unmodifiableSet(this.constants.entrySet());
    }
}

