/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.format;

import com.crowsofwar.gorecore.format.FormattedMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;

public class MultiMessage {
    private final List<FormattedMessage> chatMessages = new ArrayList<FormattedMessage>();
    private final List<Object[]> formattingArgs = new ArrayList<Object[]>();

    MultiMessage() {
    }

    public MultiMessage add(FormattedMessage message, Object ... formattingArgs) {
        this.chatMessages.add(message);
        this.formattingArgs.add(formattingArgs);
        return this;
    }

    public List<FormattedMessage> getChatMessages() {
        return this.chatMessages;
    }

    public void send(ICommandSender sender) {
        if (this.chatMessages.isEmpty()) {
            throw new IllegalArgumentException("Cannot send empty MultiMessage");
        }
        boolean plaintext = !(sender instanceof Entity);
        ITextComponent send = null;
        for (int i = 0; i < this.chatMessages.size(); ++i) {
            FormattedMessage message = this.chatMessages.get(i);
            if (send == null) {
                send = message.getChatMessage(plaintext, this.formattingArgs.get(i));
                continue;
            }
            send.func_150257_a(message.getChatMessage(plaintext, this.formattingArgs.get(i)));
        }
        sender.func_145747_a(send);
    }

    public List<Object[]> getFormattingArgs() {
        return this.formattingArgs;
    }
}

