/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;

public class ArgumentDirect<T>
implements IArgument<T> {
    private final T defaultValue;
    private final ITypeConverter<T> converter;
    private final String name;

    public ArgumentDirect(String argumentName, ITypeConverter<T> converter) {
        this(argumentName, converter, null);
    }

    public ArgumentDirect(String argumentName, ITypeConverter<T> converter, T defaultValue) {
        this.defaultValue = defaultValue;
        this.converter = converter;
        this.name = argumentName;
    }

    @Override
    public boolean isOptional() {
        return this.defaultValue != null;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T convert(String input) {
        return this.converter.convert(input);
    }

    @Override
    public String getArgumentName() {
        return this.name;
    }

    @Override
    public String getHelpString() {
        String before = this.isOptional() ? "\\[" : "<";
        String after = this.isOptional() ? "]" : ">";
        return before + "any " + this.converter.getTypeName() + after;
    }

    @Override
    public String getSpecificationString() {
        String before = this.isOptional() ? "\\[" : "<";
        String after = this.isOptional() ? "]" : ">";
        return before + this.getArgumentName() + after;
    }

    @Override
    public List<String> getCompletionSuggestions(ICommandSender sender, String currentInput) {
        return new ArrayList<String>();
    }
}

