/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.TreeCommandException;
import java.util.HashMap;
import java.util.Map;

public class ArgumentList {
    private final Map<IArgument<?>, Object> argumentValues = new HashMap();

    public ArgumentList(String[] userInput, IArgument<?>[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            IArgument<?> argument = arguments[i];
            Object out = null;
            if (i < userInput.length) {
                out = argument.convert(userInput[i]);
            } else if (argument.isOptional()) {
                out = argument.getDefaultValue();
            } else {
                throw new TreeCommandException(TreeCommandException.Reason.ARGUMENT_MISSING, arguments[i].getArgumentName());
            }
            this.argumentValues.put(argument, out);
        }
    }

    public <T> T get(IArgument<T> argument) {
        return (T)this.argumentValues.get(argument);
    }

    public int length() {
        return this.argumentValues.size();
    }
}

