/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.TreeCommandException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;

public class ArgumentOptions<T>
implements IArgument<T> {
    private final List<T> options;
    private T defaultValue;
    private final ITypeConverter<T> convert;
    private final String name;

    public ArgumentOptions(ITypeConverter<T> convert, String name, T ... options) {
        this.options = Arrays.asList(options);
        this.defaultValue = null;
        this.convert = convert;
        this.name = name;
    }

    public ArgumentOptions setOptional(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public boolean isOptional() {
        return this.defaultValue != null;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T convert(String input) {
        T converted = this.convert.convert(input);
        if (!this.options.contains(converted)) {
            throw new TreeCommandException(TreeCommandException.Reason.NOT_OPTION, input, this.getArgumentName());
        }
        return converted;
    }

    @Override
    public String getArgumentName() {
        return this.name;
    }

    @Override
    public String getHelpString() {
        String help = this.isOptional() ? "\\[" : "<";
        for (int i = 0; i < this.options.size(); ++i) {
            help = help + (i == 0 ? "" : "|") + this.convert.toString(this.options.get(i));
        }
        help = help + (this.isOptional() ? "\\]" : ">");
        return help;
    }

    @Override
    public String getSpecificationString() {
        String start = this.isOptional() ? "\\[" : "<";
        String end = this.isOptional() ? "\\]" : ">";
        return start + this.getArgumentName() + end;
    }

    @Override
    public List<String> getCompletionSuggestions(ICommandSender sender, String currentInput) {
        ArrayList<String> out = new ArrayList<String>();
        this.options.forEach(option -> out.add(this.convert.toString(option)));
        out.sort((str1, str2) -> {
            if (!currentInput.isEmpty() && str1.startsWith(currentInput)) {
                return -1;
            }
            if (!currentInput.isEmpty() && str2.startsWith(currentInput)) {
                return 1;
            }
            return str1.compareTo((String)str2);
        });
        if (!((String)out.get(0)).startsWith(currentInput)) {
            return new ArrayList<String>();
        }
        return out;
    }
}

