/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.TreeCommandException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;

public class ArgumentRangeDouble
implements IArgument<Double> {
    private final double defaultValue;
    private final boolean optional;
    private final double min;
    private final double max;
    private final String name;

    public ArgumentRangeDouble(String name, double min, double max) {
        this.name = name;
        this.defaultValue = 0.0;
        this.optional = false;
        this.min = min;
        this.max = max;
    }

    public ArgumentRangeDouble(String name, double min, double max, double defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.optional = true;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Double convert(String input) {
        double value = ITypeConverter.CONVERTER_DOUBLE.convert(input);
        if (value < this.min || value > this.max) {
            throw new TreeCommandException("gc.tree.error.rangeDouble", this.name, this.min, this.max);
        }
        return value;
    }

    @Override
    public String getArgumentName() {
        return this.name;
    }

    @Override
    public String getHelpString() {
        char open = this.isOptional() ? (char)'[' : '<';
        char close = this.isOptional() ? (char)']' : '>';
        return open + "any number " + this.min + "-" + this.max + close;
    }

    @Override
    public String getSpecificationString() {
        char open = this.isOptional() ? (char)'[' : '<';
        char close = this.isOptional() ? (char)']' : '>';
        return open + this.name + close;
    }

    @Override
    public List<String> getCompletionSuggestions(ICommandSender sender, String currentInput) {
        return new ArrayList<String>();
    }
}

