/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.TreeCommandException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;

public class ArgumentRangeInteger
implements IArgument<Integer> {
    private final int defaultValue;
    private final boolean optional;
    private final int min;
    private final int max;
    private final String name;

    public ArgumentRangeInteger(String name, int min, int max) {
        this.name = name;
        this.defaultValue = 0;
        this.optional = false;
        this.min = min;
        this.max = max;
    }

    public ArgumentRangeInteger(String name, int min, int max, int defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.optional = true;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Integer convert(String input) {
        int value = ITypeConverter.CONVERTER_INTEGER.convert(input);
        if (value < this.min || value > this.max) {
            throw new TreeCommandException("gc.tree.error.rangeInt", this.name, this.min, this.max);
        }
        return value;
    }

    @Override
    public String getArgumentName() {
        return this.name;
    }

    @Override
    public String getHelpString() {
        char open = this.isOptional() ? (char)'[' : '<';
        char close = this.isOptional() ? (char)']' : '>';
        return open + "any number " + this.min + "-" + this.max + close;
    }

    @Override
    public String getSpecificationString() {
        char open = this.isOptional() ? (char)'[' : '<';
        char close = this.isOptional() ? (char)']' : '>';
        return open + this.name + close;
    }

    @Override
    public List<String> getCompletionSuggestions(ICommandSender sender, String currentInput) {
        return new ArrayList<String>();
    }
}

