/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.tree.ArgumentList;
import com.crowsofwar.gorecore.tree.ArgumentOptions;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.TreeCommandException;
import java.util.List;

public class NodeBranch
implements ICommandNode {
    private final ICommandNode[] nodes;
    private final IArgument<String> argName;
    private final IArgument<?>[] args;
    private final String name;
    private final FormattedMessage infoMessage;

    public NodeBranch(FormattedMessage infoMessage, String name, ICommandNode ... nodes) {
        this.nodes = nodes;
        String[] possibilities = new String[nodes.length];
        for (int i = 0; i < possibilities.length; ++i) {
            possibilities[i] = nodes[i].getNodeName();
        }
        this.argName = new ArgumentOptions<String>(ITypeConverter.CONVERTER_STRING, "node-name", possibilities);
        this.args = new IArgument[]{this.argName};
        this.name = name;
        this.infoMessage = infoMessage;
    }

    @Override
    public ICommandNode execute(CommandCall call, List<String> options) {
        ArgumentList args = call.popArguments(this);
        String name = args.get(this.argName);
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].getNodeName().equals(name)) continue;
            return this.nodes[i];
        }
        throw new TreeCommandException(TreeCommandException.Reason.NO_BRANCH_NODE, name, this.getHelp());
    }

    @Override
    public boolean needsOpPermission() {
        return false;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public IArgument<?>[] getArgumentList() {
        return this.args;
    }

    @Override
    public String getHelp() {
        return this.getNodeName() + " " + this.argName.getHelpString();
    }

    public ICommandNode[] getSubNodes() {
        return this.nodes;
    }

    @Override
    public FormattedMessage getInfoMessage() {
        return this.infoMessage;
    }
}

