/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.tree.ArgumentDirect;
import com.crowsofwar.gorecore.tree.ArgumentList;
import com.crowsofwar.gorecore.tree.ArgumentPlayerName;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.NodeFunctional;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.command.ICommandSender;

public class NodeBuilder {
    private final String name;
    private boolean op;
    private final List<IArgument> args;

    public NodeBuilder(String name) {
        this.name = name;
        this.args = new ArrayList<IArgument>();
    }

    public NodeBuilder addArgument(IArgument argument) {
        this.args.add(argument);
        return this;
    }

    public NodeBuilder addArgumentDirect(String argumentName, ITypeConverter<?> converter) {
        return this.addArgument(new ArgumentDirect(argumentName, converter));
    }

    public <T> NodeBuilder addArgumentDirect(String argumentName, ITypeConverter<T> converter, T defaultValue) {
        return this.addArgument(new ArgumentDirect<T>(argumentName, converter, defaultValue));
    }

    public NodeBuilder addArgumentPlayer(String argumentName) {
        return this.addArgument(new ArgumentPlayerName(argumentName));
    }

    public NodeFunctional build(final Consumer<ArgPopper> action) {
        NodeFunctional node = new NodeFunctional(this.name, this.op){

            @Override
            protected ICommandNode doFunction(CommandCall call, List<String> options) {
                ArgumentList argList = call.popArguments(this);
                action.accept(new ArgPopper(argList, NodeBuilder.this.args, call));
                return null;
            }
        };
        for (IArgument arg : this.args) {
            node.addArgument(arg);
        }
        return node;
    }

    public static class ArgPopper {
        private ArgumentList values;
        private List<IArgument> args;
        private int nextArg;
        private final CommandCall call;

        public ArgPopper(ArgumentList values, List<IArgument> args, CommandCall call) {
            this.values = values;
            this.args = args;
            this.nextArg = 0;
            this.call = call;
        }

        public <T> T get() {
            if (this.nextArg >= this.args.size()) {
                throw new IndexOutOfBoundsException("Ran out of arguments to pop");
            }
            IArgument key = this.args.get(this.nextArg++);
            return this.values.get(key);
        }

        public ICommandSender from() {
            return this.call.getFrom();
        }
    }
}

