/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class NodeFunctional
implements ICommandNode {
    private static final FormattedMessage DEFAULT_INFO = FormattedMessage.newChatMessage("gc.tree.node.defaultInfo", new String[0]);
    private final String name;
    private final boolean op;
    private List<IArgument> args;

    public NodeFunctional(String name, boolean op) {
        this.name = name;
        this.op = op;
        this.args = new ArrayList<IArgument>();
    }

    protected <T extends IArgument<?>> T addArgument(T argument) {
        this.args.add(argument);
        return argument;
    }

    protected void addArguments(IArgument<?> ... arguments) {
        this.args.addAll(Arrays.asList(arguments));
    }

    @Override
    public final boolean needsOpPermission() {
        return this.op;
    }

    @Override
    public final String getNodeName() {
        return this.name;
    }

    @Override
    public final IArgument<?>[] getArgumentList() {
        IArgument[] arr = new IArgument[this.args.size()];
        return this.args.toArray(arr);
    }

    @Override
    public String getHelp() {
        String out = this.getNodeName();
        IArgument<?>[] args = this.getArgumentList();
        for (int i = 0; i < args.length; ++i) {
            out = out + " " + args[i].getSpecificationString();
        }
        return out;
    }

    @Override
    public final ICommandNode execute(CommandCall call, List<String> options) {
        if (options.contains("help")) {
            call.getFrom().func_145747_a((ITextComponent)new TextComponentTranslation("gc.tree.help", new Object[]{this.getHelp(), this.getNodeName()}));
            return null;
        }
        return this.doFunction(call, options);
    }

    protected abstract ICommandNode doFunction(CommandCall var1, List<String> var2);

    @Override
    public FormattedMessage getInfoMessage() {
        return DEFAULT_INFO;
    }
}

