/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.tree;

import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.format.MessageConfiguration;
import com.crowsofwar.gorecore.format.MultiMessage;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.NodeBranch;
import com.crowsofwar.gorecore.tree.TreeCommandException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class TreeCommand
implements ICommand {
    private NodeBranch branchRoot;
    protected final List<String> aliases;
    protected FormattedMessage cmdHelpTop;
    protected FormattedMessage cmdHelpNodes;
    protected FormattedMessage cmdHelpNodeItem;
    protected FormattedMessage cmdHelpSeparator;
    protected FormattedMessage cmdHelpSeparatorLast;
    protected FormattedMessage cmdHelpCommandOverview;
    protected FormattedMessage branchHelpTop;
    protected FormattedMessage branchHelpNotice;
    protected FormattedMessage branchHelpInfo;
    protected FormattedMessage branchHelpOptions;
    protected FormattedMessage branchHelpOptionsItem;
    protected FormattedMessage branchHelpOptionsSeparator;
    protected FormattedMessage branchHelpOptionsSeparatorLast;
    protected FormattedMessage branchHelpExample;
    protected FormattedMessage branchHelpDefault;
    protected FormattedMessage nodeHelpTop;
    protected FormattedMessage nodeHelpDesc;
    protected FormattedMessage nodeHelpArgs;
    protected FormattedMessage nodeHelpArgsItem;
    protected FormattedMessage nodeHelpArgsNone;
    protected FormattedMessage nodeHelpAccepted;
    protected FormattedMessage nodeHelpAcceptedItem;

    public TreeCommand() {
        this(new MessageConfiguration().addColor("value", TextFormatting.GREEN).addColor("title", TextFormatting.BLUE));
    }

    public TreeCommand(MessageConfiguration cfg) {
        this.initChatMessages(cfg);
        this.branchRoot = new NodeBranch(FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.root", "command"), this.func_71517_b(), this.addCommands());
        this.aliases = new ArrayList<String>();
    }

    public int compareTo(ICommand cmd) {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.branchRoot.getHelp();
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] arguments) throws CommandException {
        try {
            String allOptions = arguments.length > 0 ? arguments[arguments.length - 1] : "";
            boolean hasOptions = allOptions.startsWith("--");
            List<String> options = Arrays.asList(new String[0]);
            if (hasOptions) {
                options = Arrays.asList(allOptions.substring(2).split(","));
                arguments = Arrays.copyOfRange(arguments, 0, arguments.length - 1);
            }
            CommandCall call = new CommandCall(sender, arguments);
            String path = "/" + this.func_71517_b();
            ICommandNode node = this.branchRoot;
            while (node != null) {
                if (node.needsOpPermission() && !call.isOpped()) {
                    throw new TreeCommandException(TreeCommandException.Reason.NO_PERMISSION, new Object[0]);
                }
                if (call.getArgumentsLeft() == 0 && options.contains("help")) {
                    if (node instanceof NodeBranch) {
                        if (node == this.branchRoot) {
                            this.sendCommandHelp(sender);
                        } else {
                            this.sendBranchHelp(sender, (NodeBranch)node, path);
                        }
                    } else {
                        this.sendNodeHelp(sender, node);
                    }
                    node = null;
                } else {
                    node = node.execute(call, options);
                }
                if (node == null) continue;
                path = path + " " + node.getNodeName();
            }
        }
        catch (TreeCommandException e) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(e.getMessage(), e.getFormattingArgs()));
        }
    }

    public boolean func_82358_a(String[] p_82358_1_, int index) {
        return false;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] sentArgs, BlockPos pos) {
        List<String> emptyList = Arrays.asList(new String[0]);
        CommandCall call = new CommandCall(sender, sentArgs);
        ICommandNode node = this.branchRoot;
        int nodeIndex = 0;
        while (node != null) {
            if (node instanceof NodeBranch && call.getArgumentsLeft() > 1) {
                node = node.execute(call, emptyList);
                ++nodeIndex;
                continue;
            }
            IArgument<?>[] nodeArgs = node.getArgumentList();
            IArgument<?> useArg = nodeArgs[sentArgs.length - 1 - nodeIndex];
            List<String> suggestions = nodeArgs[sentArgs.length - 1 - nodeIndex].getCompletionSuggestions(sender, sentArgs[sentArgs.length - 1].toLowerCase());
            String lastArg = sentArgs[sentArgs.length - 1];
            List<String> ret = suggestions.stream().filter(suggest -> suggest.toLowerCase().startsWith(lastArg.toLowerCase())).collect(Collectors.toList());
            return ret;
        }
        return emptyList;
    }

    private void sendCommandHelp(ICommandSender sender) {
        this.cmdHelpTop.send(sender, this.func_71517_b());
        this.cmdHelpCommandOverview.send(sender, new Object[0]);
        MultiMessage multi = this.cmdHelpNodes.chain();
        ICommandNode[] allNodes = this.branchRoot.getSubNodes();
        for (int i = 0; i < allNodes.length; ++i) {
            multi.add(this.cmdHelpNodeItem, allNodes[i].getNodeName());
            if (i >= allNodes.length - 1) continue;
            FormattedMessage separator = this.cmdHelpSeparator;
            if (i == allNodes.length - 2) {
                separator = this.cmdHelpSeparatorLast;
            }
            multi.add(separator, new Object[0]);
        }
        multi.send(sender);
    }

    private void sendBranchHelp(ICommandSender sender, NodeBranch branch, String path) {
        this.branchHelpTop.send(sender, branch.getNodeName());
        this.branchHelpNotice.send(sender, new Object[0]);
        this.branchHelpInfo.chain().add(branch.getInfoMessage(), new Object[0]).send(sender);
        MultiMessage chain = this.branchHelpOptions.chain();
        ICommandNode[] subNodes = branch.getSubNodes();
        for (int i = 0; i < subNodes.length; ++i) {
            chain.add(this.branchHelpOptionsItem, subNodes[i].getNodeName());
            if (i >= subNodes.length - 1) continue;
            chain.add(i == subNodes.length - 2 ? this.branchHelpOptionsSeparatorLast : this.branchHelpOptionsSeparator, new Object[0]);
        }
        chain.send(sender);
        this.branchHelpExample.send(sender, path, subNodes[0].getNodeName());
    }

    private void sendNodeHelp(ICommandSender sender, ICommandNode node) {
        this.nodeHelpTop.send(sender, node.getNodeName());
        this.nodeHelpDesc.chain().add(node.getInfoMessage(), new Object[0]).send(sender);
        if (node.getArgumentList().length == 0) {
            this.nodeHelpArgsNone.send(sender, new Object[0]);
        } else {
            MultiMessage msgArguments = this.nodeHelpArgs.chain();
            for (IArgument<?> arg : node.getArgumentList()) {
                msgArguments.add(this.nodeHelpArgsItem, arg.getArgumentName());
            }
            msgArguments.send(sender);
            MultiMessage msgAccepted = this.nodeHelpAccepted.chain();
            for (IArgument<?> arg : node.getArgumentList()) {
                msgAccepted.add(this.nodeHelpAcceptedItem, arg.getHelpString());
            }
            msgAccepted.send(sender);
        }
    }

    protected abstract ICommandNode[] addCommands();

    private void initChatMessages(MessageConfiguration cfg) {
        this.cmdHelpTop = FormattedMessage.newChatMessage(cfg, "gc.tree.cmdhelp.top", "name");
        this.cmdHelpNodes = FormattedMessage.newChatMessage(cfg, "gc.tree.cmdhelp.nodes", new String[0]);
        this.cmdHelpNodeItem = FormattedMessage.newChatMessage(cfg, "gc.tree.cmdhelp.nodes.item", "node");
        this.cmdHelpSeparator = FormattedMessage.newChatMessage(cfg, "gc.tree.cmdhelp.nodes.separator", new String[0]);
        this.cmdHelpSeparatorLast = FormattedMessage.newChatMessage(cfg, "gc.tree.cmdhelp.nodes.separatorLast", new String[0]);
        this.cmdHelpCommandOverview = FormattedMessage.newChatMessage(cfg, "gc.tree.cmdhelp.showCmdInfo", new String[0]);
        this.branchHelpTop = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.top", "name");
        this.branchHelpNotice = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.notice", new String[0]);
        this.branchHelpInfo = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.info", new String[0]);
        this.branchHelpOptions = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.options", new String[0]);
        this.branchHelpOptionsItem = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.options.item", "node");
        this.branchHelpOptionsSeparator = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.options.separator", new String[0]);
        this.branchHelpOptionsSeparatorLast = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.options.separatorLast", new String[0]);
        this.branchHelpExample = FormattedMessage.newChatMessage(cfg, "gc.tree.branchHelp.example", "path", "node-name");
        this.branchHelpDefault = FormattedMessage.newChatMessage(cfg, "gc.tree.branch.defaultInfo", new String[0]);
        this.nodeHelpTop = FormattedMessage.newChatMessage(cfg, "gc.tree.nodeHelp.top", "name");
        this.nodeHelpDesc = FormattedMessage.newChatMessage(cfg, "gc.tree.nodeHelp.desc", new String[0]);
        this.nodeHelpArgs = FormattedMessage.newChatMessage(cfg, "gc.tree.nodeHelp.args", new String[0]);
        this.nodeHelpArgsItem = FormattedMessage.newChatMessage(cfg, "gc.tree.nodeHelp.args.item", "argument");
        this.nodeHelpArgsNone = FormattedMessage.newChatMessage(cfg, "gc.tree.nodeHelp.args.none", new String[0]);
        this.nodeHelpAccepted = FormattedMessage.newChatMessage(cfg, "gc.tree.nodeHelp.accepted", new String[0]);
        this.nodeHelpAcceptedItem = FormattedMessage.newChatMessage(cfg, "gc.tree.nodeHelp.accepted.item", "input");
    }
}

