/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.util;

import com.crowsofwar.gorecore.GoreCore;
import com.crowsofwar.gorecore.util.JsonUtils;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public final class AccountUUIDs {
    private static final Pattern DASHLESS_PATTERN = Pattern.compile("^([A-Fa-f0-9]{8})([A-Fa-f0-9]{4})([A-Fa-f0-9]{4})([A-Fa-f0-9]{4})([A-Fa-f0-9]{12})$");
    private static final Map<String, UUID> localCache = Maps.newHashMap();

    public static EntityPlayer findEntityFromUUID(World world, UUID playerID) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            UUID accountId = AccountUUIDs.getId(((EntityPlayer)world.field_73010_i.get(i)).func_70005_c_());
            if (accountId == null || !accountId.equals(playerID)) continue;
            return (EntityPlayer)world.field_73010_i.get(i);
        }
        return null;
    }

    public static UUID getId(String username) {
        Map cache = UsernameCache.getMap();
        if (!cache.containsValue(username)) {
            if (localCache.containsKey(username)) {
                return localCache.get(username);
            }
            return AccountUUIDs.requestId(username);
        }
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(username)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }

    private static UUID requestId(String username) {
        try {
            int length;
            String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
            URL obj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)obj.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            int responseCode = connection.getResponseCode();
            if (responseCode == 204) {
                GoreCore.LOGGER.warn("Attempted to get a UUID for player " + username + ", but that account is not registered");
                return null;
            }
            if (responseCode != 200) {
                GoreCore.LOGGER.warn("Attempted to get a UUID for player " + username + ", but the response code was unexpected (" + responseCode + ")");
                return null;
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            InputStream inputStream = connection.getInputStream();
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            UUID uuid = UUID.fromString(AccountUUIDs.addDashes(Objects.requireNonNull(JsonUtils.fromString(result.toString(), "id")).getAsString()));
            localCache.put(username, uuid);
            return uuid;
        }
        catch (Exception e) {
            GoreCore.LOGGER.error("Unexpected error getting UUID for " + username, (Throwable)e);
            return null;
        }
    }

    public static String getUsername(UUID id) {
        if (UsernameCache.containsUUID((UUID)id)) {
            return UsernameCache.getLastKnownUsername((UUID)id);
        }
        if (localCache.containsValue(id)) {
            for (Map.Entry<String, UUID> entry : localCache.entrySet()) {
                if (!entry.getValue().equals(id)) continue;
                return entry.getKey();
            }
        } else {
            try {
                int length;
                String idString = id.toString().replaceAll("-", "");
                String url = "https://api.mojang.com/user/profiles/" + idString + "/names";
                URL obj = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)obj.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                int responseCode = connection.getResponseCode();
                if (responseCode == 204) {
                    GoreCore.LOGGER.warn("Attempted to get a username for player " + id + ", but that account is not registered");
                    return null;
                }
                if (responseCode != 200) {
                    GoreCore.LOGGER.warn("Attempted to get a username for player " + id + ", but the response code was unexpected (" + responseCode + ")");
                    return null;
                }
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                InputStream inputStream = connection.getInputStream();
                while ((length = inputStream.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                String username = JsonUtils.fromString(result.toString(), "name").getAsString();
                localCache.put(username, id);
                return username;
            }
            catch (Exception e) {
                GoreCore.LOGGER.error("Unexpected error getting username for " + id, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static String addDashes(String uuid) {
        Matcher matcher = DASHLESS_PATTERN.matcher(uuid = uuid.replace("-", ""));
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid UUID format");
        }
        return matcher.replaceAll("$1-$2-$3-$4-$5");
    }
}

