/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.util;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;

public final class GoreCoreByteBufUtil {
    public static String readString(ByteBuf buf) {
        StringBuilder res = new StringBuilder();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            res.append(buf.readChar());
        }
        return res.toString();
    }

    public static void writeString(ByteBuf buf, String str) {
        char[] chs = str.toCharArray();
        buf.writeInt(chs.length);
        for (char ch : chs) {
            buf.writeChar((int)ch);
        }
    }

    public static UUID readUUID(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void writeUUID(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static void writeBlockPos(ByteBuf buf, BlockPos pos) {
        if (pos != null) {
            buf.writeLong(pos.func_177986_g());
        }
    }

    public static BlockPos readBlockPos(ByteBuf buf) {
        if (buf != null) {
            return BlockPos.func_177969_a((long)buf.readLong());
        }
        return new BlockPos(0, 0, 0);
    }
}

