/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.util;

public final class GoreCoreParsingResult {
    public static ResultInteger generateIntegerResult(int value, boolean successful) {
        return new ResultInteger(value, successful);
    }

    public static ResultFloat generateFloatResult(float value, boolean successful) {
        return new ResultFloat(Float.valueOf(value), successful);
    }

    public static ResultDouble generateDoubleResult(double value, boolean successful) {
        return new ResultDouble(value, successful);
    }

    public static ResultLong generateLongResult(long value, boolean successful) {
        return new ResultLong(value, successful);
    }

    public static ResultBoolean generateBooleanResult(boolean value, boolean successful) {
        return new ResultBoolean(value, successful);
    }

    public static class ResultBoolean
    extends ResultBase<Boolean> {
        public ResultBoolean(Boolean value, boolean successful) {
            super(value, successful);
        }
    }

    public static class ResultLong
    extends ResultBase<Long> {
        public ResultLong(Long value, boolean successful) {
            super(value, successful);
        }
    }

    public static class ResultDouble
    extends ResultBase<Double> {
        public ResultDouble(Double value, boolean successful) {
            super(value, successful);
        }
    }

    public static class ResultFloat
    extends ResultBase<Float> {
        public ResultFloat(Float value, boolean successful) {
            super(value, successful);
        }
    }

    public static class ResultInteger
    extends ResultBase<Integer> {
        public ResultInteger(Integer value, boolean successful) {
            super(value, successful);
        }
    }

    private static class ResultBase<T> {
        private final T value;
        private final boolean successful;

        protected ResultBase(T value, boolean successful) {
            this.value = value;
            this.successful = successful;
        }

        public T getResult() {
            return this.value;
        }

        public boolean wasSuccessful() {
            return this.successful;
        }
    }
}

