/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.util;

import com.crowsofwar.gorecore.util.VectorI;
import io.netty.buffer.ByteBuf;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class Vector {
    public static final Vector ZERO = new Vector();
    public static final Vector UP = new Vector(0.0, 1.0, 0.0);
    public static final Vector DOWN = new Vector(0.0, -1.0, 0.0);
    public static final Vector EAST = new Vector(1.0, 0.0, 0.0);
    public static final Vector WEST = new Vector(-1.0, 0.0, 0.0);
    public static final Vector NORTH = new Vector(0.0, 0.0, -1.0);
    public static final Vector SOUTH = new Vector(0.0, 0.0, 1.0);
    public static final Vector[] DIRECTION_VECTORS = new Vector[]{UP, DOWN, EAST, WEST, NORTH, SOUTH};
    private final double x;
    private final double y;
    private final double z;
    private double cachedMagnitude;

    public Vector() {
        this(0.0, 0.0, 0.0);
    }

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.cachedMagnitude = -1.0;
    }

    public Vector(Vector vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public Vector(Vec3d vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vector(Entity entity) {
        this(entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v);
    }

    public Vector(BlockPos blockPos) {
        this(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public Vector(Vec3i vec) {
        this(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public Vector(EnumFacing facing) {
        this(facing.func_176730_m());
    }

    public static Vector getRightSide(EntityLivingBase entity, double distance) {
        float angle = entity.field_70177_z / 60.0f;
        return Vector.getEntityPos((Entity)entity).minus(new Vector(Math.cos(angle), -entity.func_70047_e(), Math.sin(angle)).normalize().times(distance));
    }

    public static Vector getLeftSide(EntityLivingBase entity, double distance) {
        float angle = entity.field_70177_z / 60.0f;
        return Vector.getEntityPos((Entity)entity).plus(new Vector(Math.cos(angle), -entity.func_70047_e(), Math.sin(angle)).normalize().times(distance));
    }

    public static Vector getOrthogonalVector(Vector axis, double degrees, double length) {
        Vector ortho = new Vector(axis.y(), -axis.x(), 0.0);
        ortho = ortho.normalize();
        ortho = ortho.times(length);
        return Vector.rotateVectorAroundVector(axis, ortho, degrees);
    }

    public static Vector getOrthogonalVector(Vec3d axis, double degrees, double length) {
        Vector ortho = new Vector(axis.field_72448_b, -axis.field_72450_a, 0.0);
        ortho = ortho.normalize();
        ortho = ortho.times(length);
        return Vector.rotateVectorAroundVector(new Vector(axis.field_72450_a, axis.field_72448_b, axis.field_72449_c), ortho, degrees);
    }

    public static Vector getHelixVector(float distance, Vector axis, Vector startPosition) {
        Matrix4f rotation = Vector.withTranslation(Vector.rotationMatrix(new Vector(0.0, 1.0, 0.0), axis), startPosition);
        return Vector.rotate(rotation, MathHelper.func_76126_a((float)((float)Math.PI * 2 * distance)), distance, MathHelper.func_76134_b((float)((float)Math.PI * 2 * distance)));
    }

    public static Vector rotateVectorAroundVector(Vector axis, Vector rotator, double degrees) {
        double angle = Math.toRadians(degrees);
        Vector rotation = axis;
        rotation = rotation.normalize();
        Vector thirdaxis = rotation.cross(rotator).normalize().times(rotator.magnitude());
        return rotator.times(Math.cos(angle)).plus(thirdaxis.times(Math.sin(angle)));
    }

    private static double dot(Vector a, Vector b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    private static double angle(Vector a, Vector b) {
        return Math.acos(Vector.dot(a, b) / (a.toMinecraft().func_72433_c() * b.toMinecraft().func_72433_c()));
    }

    private static Matrix3f rotationMatrix(Vector from, Vector to) {
        Matrix3f mat = new Matrix3f();
        if (from.toMinecraft() == to.toMinecraft().func_186678_a(-1.0)) {
            mat.negate();
            return mat;
        }
        double dotAngle = Vector.angle(from, to);
        Vec3d axis = from.toMinecraft().func_72431_c(to.toMinecraft());
        mat.set(new AxisAngle4d(axis.field_72450_a, axis.field_72448_b, axis.field_72449_c, dotAngle));
        return mat;
    }

    private static Matrix4f withTranslation(Matrix3f linear, Vector translation) {
        return new Matrix4f(linear, new Vector3f((float)translation.x, (float)translation.y, (float)translation.z), 1.0f);
    }

    private static Vector rotate(Matrix4f m, double x, double y, double z) {
        double newX = (double)m.m00 * x + (double)m.m01 * y + (double)m.m02 * z + (double)m.m03;
        double newY = (double)m.m10 * x + (double)m.m11 * y + (double)m.m12 * z + (double)m.m13;
        double newZ = (double)m.m20 * x + (double)m.m21 * y + (double)m.m22 * z + (double)m.m23;
        return new Vector(newX, newY, newZ);
    }

    public static Vector reflect(Vector vec, Vector normal) {
        return vec.reflect(normal);
    }

    public static Vector getRotationTo(Vector pos1, Vector pos2) {
        Vector diff = pos2.minus(pos1).normalize();
        double x = diff.x();
        double y = diff.y();
        double z = diff.z();
        double d0 = x;
        double d1 = y;
        double d2 = z;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        double rotY = Math.atan2(d2, d0) - 1.5707963267948966;
        double rotX = -Math.atan2(d1, d3);
        double rotZ = 0.0;
        return new Vector(rotX, rotY, rotZ);
    }

    public static Vector getEntityPos(Entity entity) {
        return new Vector(entity);
    }

    public static Vector getEyePos(Entity entity) {
        return Vector.getEntityPos(entity).plus(0.0, entity.func_70047_e(), 0.0);
    }

    public static Vector getVelocity(Entity entity) {
        return new Vector(entity.field_70159_w * 20.0, entity.field_70181_x * 20.0, entity.field_70179_y * 20.0);
    }

    public static double getProjectileAngle(double v, double g, double x, double y) {
        return -Math.atan2(v * v + Math.sqrt(v * v * v * v - g * (g * x * x + 2.0 * y * v * v)), g * x);
    }

    public static Vector getLookRectangular(Entity entity) {
        return Vector.toRectangular(Math.toRadians(entity.field_70177_z), Math.toRadians(entity.field_70125_A));
    }

    public static Vector getLookRotations(Entity entity) {
        return Vector.getEuler(Math.toRadians(entity.field_70177_z), Math.toRadians(entity.field_70125_A));
    }

    public static Vector rotateAroundAxisX(Vector v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.y() * cos - v.z() * sin;
        double z = v.y() * sin + v.z() * cos;
        return new Vector(v.x(), y, z);
    }

    public static Vector rotateAroundAxisY(Vector v, double angle) {
        angle = -angle;
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.x() * cos + v.z() * sin;
        double z = v.x() * -sin + v.z() * cos;
        return new Vector(x, v.y(), z);
    }

    public static Vector rotateAroundAxisZ(Vector v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.x() * cos - v.y() * sin;
        double y = v.x() * sin + v.y() * cos;
        return new Vector(x, y, v.z());
    }

    public static Vector getEuler(double yaw, double pitch) {
        return new Vector(pitch, yaw, 0.0);
    }

    public static Vector toRectangular(Vector euler) {
        return new Vector(-Math.sin(euler.y()) * Math.cos(euler.x()), -Math.sin(euler.x()), Math.cos(euler.y()) * Math.cos(euler.x()));
    }

    public static Vector toRectangular(double yaw, double pitch) {
        return new Vector(-Math.sin(yaw) * Math.cos(pitch), -Math.sin(pitch), Math.cos(yaw) * Math.cos(pitch));
    }

    public static Vector fromVec3d(Vec3d vec3d) {
        return new Vector(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public static Vector fromBytes(ByteBuf buf) {
        return new Vector(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static Vector readFromNbt(NBTTagCompound nbt) {
        return new Vector(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Vector withX(double x) {
        return new Vector(x, this.y, this.z);
    }

    public Vector withY(double y) {
        return new Vector(this.x, y, this.z);
    }

    public Vector withZ(double z) {
        return new Vector(this.x, this.y, z);
    }

    public Vector plus(Vector vec) {
        return this.plus(vec.x(), vec.y(), vec.z());
    }

    public Vector plus(double x, double y, double z) {
        return new Vector(this.x + x, this.y + y, this.z + z);
    }

    public Vector plusX(double x) {
        return this.plus(x, 0.0, 0.0);
    }

    public Vector plusY(double y) {
        return this.plus(0.0, y, 0.0);
    }

    public Vector plusZ(double z) {
        return this.plus(0.0, 0.0, z);
    }

    public Vector minus(Vector vec) {
        return this.minus(vec.x(), vec.y(), vec.z());
    }

    public Vector minus(double x, double y, double z) {
        return new Vector(this.x - x, this.y - y, this.z - z);
    }

    public Vector minusX(double x) {
        return this.minus(x, 0.0, 0.0);
    }

    public Vector minusY(double y) {
        return this.minus(0.0, y, 0.0);
    }

    public Vector minusZ(double z) {
        return this.minus(0.0, 0.0, z);
    }

    public Vector times(double scalar) {
        return new Vector(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector dividedBy(double scalar) {
        return new Vector(this.x / scalar, this.y / scalar, this.z / scalar);
    }

    public double magnitude() {
        if (this.cachedMagnitude == -1.0) {
            this.cachedMagnitude = Math.sqrt(this.sqrMagnitude());
        }
        return this.cachedMagnitude;
    }

    public double sqrMagnitude() {
        return this.x() * this.x() + this.y() * this.y() + this.z() * this.z();
    }

    public Vector normalize() {
        return this.dividedBy(this.magnitude());
    }

    public boolean isNormalized() {
        double length = this.sqrMagnitude();
        return Math.abs(length - 1.0) <= 0.001;
    }

    public double sqrDist(Vector vec) {
        return this.sqrDist(vec.x(), vec.y(), vec.z());
    }

    public double sqrDist(double x, double y, double z) {
        return (this.x() - x) * (this.x() - x) + (this.y() - y) * (this.y() - y) + (this.z() - z) * (this.z() - z);
    }

    public double dist(Vector vec) {
        return Math.sqrt(this.sqrDist(vec));
    }

    public double dist(double x, double y, double z) {
        return Math.sqrt(this.sqrDist(x, y, z));
    }

    public double dot(Vector vec) {
        return this.dot(vec.x(), vec.y(), vec.z());
    }

    public double dot(double x, double y, double z) {
        return this.x() * x + this.y() * y + this.z() * z;
    }

    public Vector cross(Vector vec) {
        return this.cross(vec.x(), vec.y(), vec.z());
    }

    public Vector cross(double x, double y, double z) {
        return new Vector(this.y() * z - this.z() * y, this.z() * x - this.x() * z, this.x() * y - this.y() * x);
    }

    public double angle(Vector vec) {
        double dot = this.dot(vec);
        return Math.acos(dot / (this.magnitude() * vec.magnitude()));
    }

    public Vector reflect(Vector normal) {
        if (!normal.isNormalized()) {
            throw new IllegalArgumentException("Normal vector must be normalized");
        }
        return this.minus(normal.times(2.0).times(this.dot(normal)));
    }

    public Vector toRectangular() {
        return Vector.toRectangular(this);
    }

    public Vector toSpherical() {
        return Vector.getRotationTo(ZERO, this);
    }

    public Vec3d toMinecraft() {
        return new Vec3d(this.x(), this.y(), this.z());
    }

    public VectorI round() {
        return new VectorI((int)Math.round(this.x()), (int)Math.round(this.y()), (int)Math.round(this.z()));
    }

    public VectorI cast() {
        return new VectorI((int)this.x(), (int)this.y(), (int)this.z());
    }

    public BlockPos toBlockPos() {
        return this.cast().toBlockPos();
    }

    public Vec3i toMinecraftInteger() {
        return new Vec3i(this.x(), this.y(), this.z());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x());
        buf.writeDouble(this.y());
        buf.writeDouble(this.z());
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x());
        nbt.func_74780_a("y", this.y());
        nbt.func_74780_a("z", this.z());
    }

    public String toString() {
        return "(" + this.x() + ", " + this.y() + ", " + this.z() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Vector) {
            Vector vec = (Vector)obj;
            return this.x() == vec.x() && this.y() == vec.y() && this.z() == vec.z();
        }
        return false;
    }
}

