/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.gorecore.util;

import com.crowsofwar.gorecore.util.Vector;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class VectorI {
    private double cachedMagnitude;
    private int x;
    private int y;
    private int z;

    public VectorI() {
        this(0, 0, 0);
    }

    public VectorI(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.recalcMagnitude();
    }

    public VectorI(VectorI vec) {
        this(vec.x, vec.y, vec.z);
        this.cachedMagnitude = vec.cachedMagnitude;
    }

    public VectorI(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int x() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
        this.recalcMagnitude();
    }

    public int y() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        this.recalcMagnitude();
    }

    public int z() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
        this.recalcMagnitude();
    }

    public VectorI set(int x, int y, int z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    public VectorI set(VectorI vec) {
        this.set(vec.x, vec.y, vec.z);
        return this;
    }

    public VectorI createCopy() {
        return new VectorI(this);
    }

    public VectorI add(VectorI vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public VectorI add(int x, int y, int z) {
        return this.set(this.x + x, this.y + y, this.z + z);
    }

    public VectorI plus(VectorI vec) {
        return this.plus(vec.x, vec.y, vec.z);
    }

    public VectorI plus(int x, int y, int z) {
        return new VectorI(this).add(x, y, z);
    }

    public VectorI subtract(VectorI vec) {
        return this.subtract(vec.x, vec.y, vec.z);
    }

    public VectorI subtract(int x, int y, int z) {
        return this.set(this.x - x, this.y - y, this.z - z);
    }

    public VectorI minus(VectorI vec) {
        return this.minus(vec.x, vec.y, vec.z);
    }

    public VectorI minus(int x, int y, int z) {
        return new VectorI(this).subtract(x, y, z);
    }

    public VectorI mul(int scalar) {
        return this.set(this.x() * scalar, this.y() * scalar, this.z() * scalar);
    }

    public VectorI times(int scalar) {
        return new VectorI(this).mul(scalar);
    }

    public void offset(EnumFacing direction) {
        this.offset(direction, 1);
    }

    public void offset(EnumFacing direction, int distance) {
        switch (direction.func_176740_k()) {
            case X: {
                this.x += direction.func_176743_c().func_179524_a() * distance;
                break;
            }
            case Y: {
                this.y += direction.func_176743_c().func_179524_a() * distance;
                break;
            }
            case Z: {
                this.z += direction.func_176743_c().func_179524_a() * distance;
            }
        }
    }

    public double magnitude() {
        if (this.cachedMagnitude == -1.0) {
            this.cachedMagnitude = Math.sqrt(this.sqrMagnitude());
        }
        return this.cachedMagnitude;
    }

    public double sqrMagnitude() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    private void recalcMagnitude() {
        this.cachedMagnitude = -1.0;
    }

    public double sqrDist(VectorI vec) {
        return this.sqrDist(vec.x, vec.y, vec.z);
    }

    public double sqrDist(int x, int y, int z) {
        return (this.x - x) * (this.x - x) + (this.y - y) * (this.y - y) + (this.z - z) * (this.z - z);
    }

    public double dist(VectorI vec) {
        return Math.sqrt(this.sqrDist(vec));
    }

    public double dist(int x, int y, int z) {
        return Math.sqrt(this.sqrDist(x, y, z));
    }

    public double dot(VectorI vec) {
        return this.dot(vec.x, vec.y, vec.z);
    }

    public double dot(int x, int y, int z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public VectorI cross(VectorI vec) {
        return this.cross(vec.x, vec.y, vec.z);
    }

    public VectorI cross(int x, int y, int z) {
        return new VectorI(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public double angle(VectorI vec) {
        double dot = this.dot(vec);
        return Math.acos(dot / (this.magnitude() * vec.magnitude()));
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vector precision() {
        return new Vector(this.x, this.y, this.z);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static VectorI fromBytes(ByteBuf buf) {
        return new VectorI(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

