/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.client.entity.render.entity.spell;

import com.danny.dannys_expansion.common.Entities.AbstractSpellEntity;
import com.danny.dannys_expansion.core.animation.SpellEntityModel;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public abstract class SpellRenderer<M extends SpellEntityModel<E>, E extends AbstractSpellEntity>
extends EntityRenderer<E>
implements IEntityRenderer<E, M> {
    private static final ResourceLocation TEXTURES = null;
    M entityModel;
    protected final List<LayerRenderer<E, M>> layerRenderers = Lists.newArrayList();
    public boolean shouldLookPitch;

    public SpellRenderer(EntityRendererManager renderManagerIn, M entityModelIn) {
        super(renderManagerIn);
        this.entityModel = entityModelIn;
    }

    public final boolean addLayer(LayerRenderer<E, M> layer) {
        return this.layerRenderers.add(layer);
    }

    public void render(E entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)((AbstractSpellEntity)((Object)entityIn)).prevSpellYaw, (float)((AbstractSpellEntity)((Object)entityIn)).spellYaw);
        float f2 = MathHelper.func_219805_h((float)partialTicks, (float)((AbstractSpellEntity)((Object)entityIn)).prevSpellPitch, (float)((AbstractSpellEntity)((Object)entityIn)).spellPitch);
        if (this.shouldLookPitch) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f - f2));
        }
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f1));
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.getRenderType(entityIn));
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
        this.preRender(entityIn, matrixStackIn, partialTicks);
        float ageInTicks = this.handleRotationFloat(entityIn, partialTicks);
        ((SpellEntityModel)((Object)this.entityModel)).getPartialTick(partialTicks);
        ((SpellEntityModel)((Object)this.entityModel)).setRotationAngles(entityIn, 0.0f, 0.0f, 0.0f, f1, f2);
        ((SpellEntityModel)((Object)this.entityModel)).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (LayerRenderer<E, M> layerrenderer : this.layerRenderers) {
            layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, entityIn, 1.0f, 0.0f, partialTicks, ageInTicks, f1, f2);
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public RenderType getRenderType(E entityIn) {
        return RenderType.func_228640_c_((ResourceLocation)this.getEntityTexture(entityIn));
    }

    public M getEntityModel() {
        return this.entityModel;
    }

    public void preRender(E entityIn, MatrixStack matrixStackIn, float partialTicks) {
    }

    protected float handleRotationFloat(E livingBase, float partialTicks) {
        return (float)((AbstractSpellEntity)((Object)livingBase)).field_70173_aa + partialTicks;
    }

    public ResourceLocation getEntityTexture(E entity) {
        return TEXTURES;
    }
}

